﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Data;
using System.Data.Common;
using System.Configuration;

namespace EventCalendar.DataAccessLayer
{
    public class DatabaseConnection:IDatabaseConnection
    {
        private string _providerName = ConfigurationManager.AppSettings["DataAccessLayer.ProviderName"];
        private string _connectionString = ConfigurationManager.AppSettings["DataAccessLayer.ConnectionString"];
        private DbProviderFactory _providerFactory;
        private IDbConnection _connection;

        public DatabaseConnection()
        {
            _providerFactory = DbProviderFactories.GetFactory(_providerName);
            OpenConnection();
        }
        private void OpenConnection()
        {
            _connection = _providerFactory.CreateConnection();
            _connection.ConnectionString = _connectionString;
            _connection.Open();
        }
        private void CloseConnection()
        {
            _connection.Close();
        }
        System.Data.IDbConnection IDatabaseConnection.GetConnection
        {
            get { return _connection; }
        }

        System.Data.IDbCommand IDatabaseConnection.CreateCommand(string dynamicSQLExpression, CommandTypes cmdType)
        {
            IDbCommand command = _connection.CreateCommand();            
            command.CommandText = dynamicSQLExpression;
            switch (cmdType)
            {
                case CommandTypes.StoredProcedure:
                    command.CommandType = CommandType.StoredProcedure;
                    break;
                case CommandTypes.Query:
                    command.CommandType = CommandType.Text;
                    break;
                default:
                    break;
            }
            return command;
        }

        IDbDataAdapter IDatabaseConnection.CreateAdapter(IDbCommand command)
        {
            IDbDataAdapter da = _providerFactory.CreateDataAdapter();
           
            da.SelectCommand = command;
            return da;            
        }

        void IDisposable.Dispose()
        {
            CloseConnection();
            _connection.Dispose();
        }
    }
}
