﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Data;
using System.Data.Common;
using System.Configuration;
using EventCalendar.DataAccessLayer;
using System.Collections.Generic;
using System.Collections;

namespace EventCalendar.Business.Events
{
    public class Month
    {        
        public Month() { }

        public Month(byte monthID)
        {            
            this.MonthID = monthID;
        }
        public byte MonthID { get; set; }
        public string MonthName { get; set; }
        public string Year { get; set; }
        public List<Event> Events
        {
            get
            {                
                DatabaseGateway dal = new DatabaseGateway();
                Hashtable parameters = new Hashtable();
                parameters.Add("@Year", Year);
                DataTable dtYear=dal.ExecuteQuery("SELECT YearId FROM YEAR WHERE Year = @Year",parameters);
                int YearId = Convert.ToInt16(dtYear.Rows[0][0]);

                string sqlQuery = ConfigurationManager.AppSettings["DataAccessLayer.spEventQuery"];
                dal = new DatabaseGateway();
                parameters = new Hashtable();
                parameters.Add("@yearId", YearId);
                parameters.Add("@monthId", MonthID);

                DataTable dtEvents = dal.ExecuteStoredProcedure(sqlQuery,parameters);
                List<Event> events = new List<Event>();

                for (int rowCount = 0; rowCount < dtEvents.Rows.Count; rowCount++)
                {
                    Event e = new Event();
                    e.Date = Convert.ToString(dtEvents.Rows[rowCount]["Date"]);
                    e.Description = Convert.ToString(dtEvents.Rows[rowCount]["Description"]);
                    e.Link =Convert.ToString(dtEvents.Rows[rowCount]["Link"]);

                    events.Add(e);
                }
                return events;
            }
        }
    }
}
