﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Data;
using EventCalendar.DataAccessLayer;
using System.Collections.Generic;
using System.Configuration;

namespace EventCalendar.Business.Events
{
    public class Calendar
    {
        public Calendar(){}

        public string Year { get; set; }
        
        public List<Month> Months
        {
            get
            {
                string sqlQuery = ConfigurationManager.AppSettings["DataAccessLayer.spMonthQuery"];
                DatabaseGateway dal = new DatabaseGateway();

                DataTable dtMonths = dal.ExecuteStoredProcedure(sqlQuery);
                List<Month> months = new List<Month>();

                for (int rowCount = 0; rowCount < dtMonths.Rows.Count; rowCount++)
                {
                    Month m = new Month();
                    m.MonthID = Convert.ToByte(dtMonths.Rows[rowCount]["MonthId"]);
                    m.MonthName = Convert.ToString(dtMonths.Rows[rowCount]["Month"]);
                    m.Year = Year;
                    months.Add(m);
                }                
                return months;
            }            
        }       
    }
}
