using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Mvc.Ajax;
using DevOrigin.ToDoList.Data;
using DevOrigin.ToDoList.Service;

namespace DevOrigin.ToDoList.Controllers
{
  public class ToDoItemController : Controller
  {
    #region .ctor
    ITaskItemService _taskItemSvc;
    ITrashedTaskItemService _trashedTaskItemSvc;

    public ToDoItemController(ITaskItemService svc)
    {
      _taskItemSvc = svc;
    }

    public ToDoItemController(ITrashedTaskItemService svc)
    {
      _trashedTaskItemSvc = svc;
    }

    public ToDoItemController(ITaskItemService svc, ITrashedTaskItemService trashSvc)
    {
      _taskItemSvc = svc;
      _trashedTaskItemSvc = trashSvc;
    }
    #endregion

    #region Details
    public ActionResult Index()
    {
      return View(new TaskItemViewModel().GetList(_taskItemSvc.GetItems()));
    }

    public ActionResult Details(int id)
    {
      TaskItem taskItem = _taskItemSvc.GetItem(id);
      return View(new TaskItemViewModel(taskItem, taskItem.Priority));
    }
    #endregion

    #region Create
    public ActionResult Create()
    {
      TaskItem item = new TaskItem();
      return View(new TaskItemViewModel(item, 0));
    }

    [AcceptVerbs(HttpVerbs.Post)]
    public ActionResult Create(FormCollection collection)
    {
      TaskItem itemToCreate = new TaskItem();

      try
      {
        UpdateModel(itemToCreate, collection.AllKeys);

        _taskItemSvc.InsertTaskItem(itemToCreate);
        return RedirectToAction("Index");
      }
      catch
      {
        foreach (var issue in itemToCreate.GetRuleViolations())
          ModelState.AddModelError(issue.PropertyName, issue.ErrorMessage);

        return View(new TaskItemViewModel(itemToCreate, itemToCreate.Priority));
      }
    }
    #endregion

    #region Edit
    public ActionResult Edit(int id)
    {
      TaskItem taskItem = _taskItemSvc.GetItem(id);
      return View(new TaskItemViewModel(taskItem, taskItem.Priority));
    }

    [AcceptVerbs(HttpVerbs.Post)]
    public ActionResult Edit(int id, FormCollection collection)
    {
      TaskItem itemToUpdate = new TaskItem();

      try
      {
        UpdateModel(itemToUpdate, collection.AllKeys);

        _taskItemSvc.UpdateTaskItem(itemToUpdate);
        return RedirectToAction("Index");
      }
      catch
      {
        foreach (var issue in itemToUpdate.GetRuleViolations())
          ModelState.AddModelError(issue.PropertyName, issue.ErrorMessage);

        TaskItem taskItem = _taskItemSvc.GetItem(id);
        return View(new TaskItemViewModel(taskItem, taskItem.Priority));
      }
    }
    #endregion

    #region Delete
    public ActionResult Delete(int id)
    {
      return View(_taskItemSvc.GetItem(id));
    }

    [AcceptVerbs(HttpVerbs.Post)]
    public ActionResult Delete(int id, string confirmButton)
    {
      try
      {
        _taskItemSvc.DeleteTaskItem(id);
        return RedirectToAction("Index");
      }
      catch
      {
        return View(_taskItemSvc.GetItem(id));
      }
    }
    #endregion

    #region Accomplish Item
    public ActionResult Accomplish(int id)
    {
      TaskItem taskItem = _taskItemSvc.GetItem(id);
      return View(new TrashedTaskItemViewModel(taskItem, taskItem.Priority));
    }

    [AcceptVerbs(HttpVerbs.Post)]
    public ActionResult Accomplish(int id, string confirmButton)
    {
      try
      {
        _taskItemSvc.AccomplishTaskItem(id);
        return RedirectToAction("Index");
      }
      catch
      {
        TaskItem taskItem = _taskItemSvc.GetItem(id);
        return View(new TrashedTaskItemViewModel(taskItem, taskItem.Priority));
      }
    }
    #endregion

  }
}
