﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using StructureMap;
using StructureMap.Configuration.DSL;
using StructureMap.Configuration;
using DevOrigin.ToDoList.Service;
using DevOrigin.ToDoList.Data;
using StructureMap.Attributes;
using DevOrigin.ToDoList.Data.SqlRepository;

namespace DevOrigin.ToDoList.Web
{
  public class Bootstrapper
  {
    public static void ConfigureStructureMap()
    {
      StructureMapConfiguration.AddRegistry(new DBServiceRegistry());
      StructureMapConfiguration.AddRegistry(new ToDoListRegistry());
    }

    public class ToDoListRegistry : Registry
    {
      protected override void configure()
      {
        ForRequestedType<ITaskItemService>()
          .TheDefaultIsConcreteType<TaskItemService>();

        ForRequestedType<ITrashedTaskItemService>()
          .TheDefaultIsConcreteType<TrashedTaskItemService>();

        ForRequestedType<ITaskItemRepository>()
          .TheDefaultIsConcreteType<SqlTaskItemRepository>();

        ForRequestedType<ITrashedTaskItemRepository>()
          .TheDefaultIsConcreteType<SqlTrashedTaskItemRepository>();

        ForRequestedType<ILogger>()
          .TheDefaultIsConcreteType<NLogLogger>();
      }
    }
  }
}
