﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DevOrigin.ToDoList.Data;

namespace DevOrigin.ToDoList.Service
{
  public class TrashedTaskItemService : ITrashedTaskItemService
  {
    ITrashedTaskItemRepository _trashRepository = null;

    public TrashedTaskItemService(ITrashedTaskItemRepository repository)
    {
      _trashRepository = repository;
      if (_trashRepository == null)
        throw new InvalidOperationException("Repository cannot be null.");
    }

    #region ITaskItemService Members

    /// <summary>
    /// Gets the task-items from the DB.
    /// </summary>
    /// <returns>TaskItem Collection</returns>
    public IList<TrashedTaskItem> GetItems()
    {
      return _trashRepository.GetItems().ToList();
    }

    /// <summary>
    /// Returns a single trashed task-item by ID.
    /// </summary>
    /// <param name="itemId">The Task-item ID for which filtering is done.</param>
    /// <returns>TrashedTaskItem object</returns>
    public TrashedTaskItem GetItem(int itemId)
    {
      TrashedTaskItem result = _trashRepository.GetItems()
                        .SingleOrDefault(x => x.ItemId == itemId);
      return result;
    }

    #endregion
  }
}