﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DevOrigin.ToDoList.Data;

namespace DevOrigin.ToDoList.Service
{
  public class TaskItemService : ITaskItemService
  {
    ITaskItemRepository _repository = null;

    #region .ctor

    /// <summary>
    /// Creates a ToDoItem service based on the input repository interface.
    /// </summary>
    /// <param name="repository">An IToDoItemRepository interface object</param>
    public TaskItemService(ITaskItemRepository repository)
    {
      _repository = repository;
      if (_repository == null)
        throw new InvalidOperationException("Repository cannot be null.");
    }

    #endregion

    #region ITaskItemService Members

    /// <summary>
    /// Gets the task-items from the DB.
    /// </summary>
    /// <returns>TaskItem Collection</returns>
    public IList<TaskItem> GetItems()
    {
      return _repository.GetItems().ToList();
    }

    /// <summary>
    /// Returns a single task-tem by ID.
    /// </summary>
    /// <param name="itemId">The Task-item ID for which filtering is done.</param>
    /// <returns>TaskItem object</returns>
    public TaskItem GetItem(int itemId)
    {
      TaskItem result = _repository.GetItems()
                        .SingleOrDefault(x => x.ItemId == itemId);
      return result;
    }

    public TaskItem GetDefaultItem()
    {
      throw new NotImplementedException();
    }

    public void InsertTaskItem(TaskItem item)
    {
      _repository.InsertTaskItem(item);
    }

    public void UpdateTaskItem(TaskItem item)
    {
      _repository.UpdateTaskItem(item);
    }

    public void DeleteTaskItem(int itemId)
    {
      _repository.Delete(itemId);
    }

    public void AccomplishTaskItem(int itemId)
    {
      _repository.AccomplishTaskItem(itemId);
    }

    #endregion
  }
}
