﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DevOrigin.ToDoList.Data
{
  public partial class TaskItem
  {
    public bool IsValid
    {
      get { return (GetRuleViolations().Count() == 0); }
    }

    public IEnumerable<RuleViolation> GetRuleViolations()
    {
      if (string.IsNullOrEmpty(Title))
        yield return new RuleViolation("Task title is required.", "Title");

      if (Priority <= 0 || Priority > 3)
        yield return new RuleViolation("Priority must lie between 1 to 3.", "Priority");

      if (DueDate != null && DueDate < StartDate)
        yield return new RuleViolation("Due date must be greater than start date.", "Due Date");

      if (PercentCompleted != null && (PercentCompleted <= 0 || PercentCompleted > 100))
        yield return new RuleViolation("Please specify Percentage completed between 1 to 100.",
            "Percentage Completed");

      yield break;
    }
  }
}
