﻿///****************************************
///Multi culture Calandar
///Copyright © 2008 Farshid Mirzagholi
///****************************************
using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Common.Control
{
    
    [ToolboxData("<{0}:MultiCultureCalendar runat=server></{0}:MultiCultureCalendar>")]
    [DataBindingHandler("System.Web.UI.Design.WebControls.CalendarDataBindingHandler, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
    [ControlValueProperty("SelectedDate", typeof(DateTime), "1/1/0001")]
    [Designer("System.Web.UI.Design.WebControls.CalendarDesigner, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
    [SupportsEventValidation]
    [DefaultEvent("SelectionChanged")]
    [DefaultProperty("SelectedDate")]
    public class MultiCultureCalendar : Calendar
    {
        [Browsable(true)]
        public string Culture { get; set; }

        private System.Globalization.CultureInfo selectedCulture;
        private System.Globalization.CultureInfo SelectedCulture
        {
            get
            {
                if (selectedCulture == null)
                {
                    if (Culture == null)
                    {
                        Culture = "en-US";
                    }
                    selectedCulture = new System.Globalization.CultureInfo(Culture);
                }
                return selectedCulture;
            }
        }

        private System.Globalization.CultureInfo DefaultCulture { get; set; }

        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
                      
        }
        
        protected override void Render(HtmlTextWriter writer)
        {
            ChangeCulture(); 
            base.Render(writer);

            System.Threading.Thread.CurrentThread.CurrentCulture = DefaultCulture;
            System.Threading.Thread.CurrentThread.CurrentUICulture = DefaultCulture;
        }
        protected override void OnUnload(EventArgs e)
        {
            
            base.OnUnload(e);
            
        }

        private void ChangeCulture()
        {
            DefaultCulture = new System.Globalization.CultureInfo(System.Threading.Thread.CurrentThread.CurrentUICulture.Name);
            switch (SelectedCulture.Name)
            {
                case "fa-IR":
                    System.Globalization.DateTimeFormatInfo info = SelectedCulture.DateTimeFormat;
                    info.AbbreviatedDayNames = new string[] { "ی", "د", "س", "چ", "پ", "ج", "ش" };
                    info.DayNames = new string[] { "یکشنبه", "دوشنبه", "ﺳﻪشنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه" };
                    info.AbbreviatedMonthNames = new string[] { "فروردین", "ارديبهشت", "خرداد", "تير", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند", "" };
                    info.MonthNames = new string[] { "فروردین", "ارديبهشت", "خرداد", "تير", "مرداد", "شهریور", "مهر", "آبان", "آذر", "دی", "بهمن", "اسفند", "" };
                    info.AMDesignator = "ق.ظ";
                    info.PMDesignator = "ب.ظ";
                    info.ShortDatePattern = "yyyy/MM/dd";
                    info.FirstDayOfWeek = DayOfWeek.Saturday;
                    System.Globalization.PersianCalendar cal = new System.Globalization.PersianCalendar();

                    typeof(System.Globalization.DateTimeFormatInfo).GetField("calendar", System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic).SetValue(info, cal);
                    object obj = typeof(System.Globalization.DateTimeFormatInfo).GetField("m_cultureTableRecord", System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic).GetValue(info);
                    obj.GetType().GetMethod("UseCurrentCalendar", System.Reflection.BindingFlags.NonPublic | System.Reflection.BindingFlags.Instance).Invoke(obj, new object[] { cal.GetType().GetProperty("ID", System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic).GetValue(cal, null) });
                    typeof(System.Globalization.CultureInfo).GetField("calendar", System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.Instance | System.Reflection.BindingFlags.NonPublic).SetValue(SelectedCulture, cal);
 
                    System.Threading.Thread.CurrentThread.CurrentCulture = SelectedCulture;
                    System.Threading.Thread.CurrentThread.CurrentUICulture = SelectedCulture;
                    System.Globalization.CultureInfo.CurrentCulture.DateTimeFormat = info;
                    System.Globalization.CultureInfo.CurrentUICulture.DateTimeFormat = info;
                    break;
               

                   
                default:
                    System.Threading.Thread.CurrentThread.CurrentCulture = SelectedCulture;
                    System.Threading.Thread.CurrentThread.CurrentUICulture = SelectedCulture;
                    break;
            }
            
        }
    }
}
