﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Text;
using TestUploadProject;
using System.IO;
using System.Threading;

namespace FileUpload
{
    /// <summary>
    /// This control responsible for downloading the file to server and 
    /// creating/updating the progress bar
    /// </summary>
    public partial class UploadProgressBar : System.Web.UI.UserControl
    {


        /// <summary>
        /// This function creates Progress bar for each of the file selecting during the upload process 
        /// </summary>
        /// <param name="fileCollection"></param>
        public void CreateProgress(HttpFileCollection fileCollection)
        {
            //string fileName, int id, string progressAmount
            StringBuilder sbProgress = new StringBuilder();
            sbProgress.Append("<html><head><LINK REL=StyleSheet HREF='StyleSheet1.css' TYPE='text/css' /></head>  <body>");
            sbProgress.Append("<script src='JScript1.js' type='text/javascript'></script><table id='mainTable' border='1'>");
            for (int i = 0; i < fileCollection.Count; i++)
            {

                string strProgressBarId = "progressBar" + i;
                string strPercentageId = "percentage" + i;
                string fileName = fileCollection[i].FileName;
                sbProgress.Append("<tr><td><p>" + fileName + "</p></td><td><div id='xxx' style='background-color:White; width: 100px;height:15px; border-color:Black;border-width:thin;border-style:solid'>");
                sbProgress.Append("<div class='progressBar'  id='" + strProgressBarId + "' ></div></div></td><td><p><div id='" + strPercentageId + "'></div></p></td></tr>");

            }
            sbProgress.Append("</table>");
            for (int i = 0; i < fileCollection.Count; i++)
            {
                sbProgress.Append("<script type='text/javascript'> SetProgressBarProgressAmount(" + i + ",0 );</script>");
            }
            sbProgress.Append(PrepareTheGridHtml());
            sbProgress.Append("</body></html>");

            HttpContext.Current.Response.Write(sbProgress.ToString());

            HttpContext.Current.Response.Flush();

        }
        /// <summary>
        /// this method responsible for showing previously uploaded files while progress in action
        /// </summary>
        /// <returns></returns>
        public string PrepareTheGridHtml()
        {

            StringBuilder sb = new StringBuilder();
            sb.Append(" <div><table cellspacing=\"0\" rules=\"all\" border=\"1\" id=\"Uploader1_GridView1\" style=\"border-collapse:collapse;\">");
            sb.Append("<tr><th scope=\"col\"><p>FileName</p></th><th scope=\"col\"><p>FileSize</p></th><th scope=\"col\"><p>FileContentType</p></th></tr>");
            sb.Append(PrepareRows());
            sb.Append("</table></div>");
            return sb.ToString();

        }
        /// <summary>
        ///  this method responsible for showing previously uploaded files while progress in action
        /// </summary>
        /// <returns></returns>
        public StringBuilder PrepareRows()
        {
            StringBuilder sb = new StringBuilder();
            if (Session["FilesUploaded"] != null)
            {
                UploadedFileCollection fileCollection = new UploadedFileCollection();
                fileCollection.Files = (System.Collections.Generic.List<UploadedFile>)(Session["FilesUploaded"]);
                foreach (UploadedFile file in fileCollection.Files)
                {
                    sb.Append("<tr>");
                    sb.Append("<td><p>" + file.FileName + "</p></td>");
                    sb.Append("<td><p>" + file.FileSize + "</p></td>");
                    sb.Append("<td><p>" + file.FileContentType + "</p></td>");
                    sb.Append("</tr>");
                }

            }

            return sb;
        }

        /// <summary>
        /// Method responsible for setting the progress bar amount
        /// </summary>
        /// <param name="id"> id of the progress bar when there are more than one files to upload</param>
        /// <param name="progressAmount"></param>
        public static void setProgressBar(int id, string progressAmount)
        {

            StringBuilder sb = new StringBuilder();

            sb.Append("<body><script type='text/javascript'>SetProgressBarProgressAmount(" + id + ",'" + progressAmount + "'); </script></body>");

            HttpContext.Current.Response.Write(sb.ToString());

            HttpContext.Current.Response.Flush();

        }

        //Javascript function to clear progressbar
        /// <summary>
        /// Clear the progress bar once all the files uploaded
        /// </summary>
        public static void RemoveProgress()
        {

            StringBuilder sbc = new StringBuilder();

            sbc.Append("<body><script language='javascript'>");

            sbc.Append("var up_div=document.getElementById('mainTable');");
            sbc.Append("up_div.style.display='none';");
            sbc.Append("var gv1 = document.getElementById('Uploader1_GridView1');");
            sbc.Append("gv1.style.display = 'none';");
            sbc.Append("</script></body>");

            HttpContext.Current.Response.Write(sbc);

        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnUpload_Click(object sender, EventArgs e)
        {
            try
            {
                // Since we are flushing out the output stream, Session state may not be saved properly 
                //to ensure this below line makes sure session state will be maintained properly 
                string str = Session.SessionID;
                HttpFileCollection UploadedFiles = this.Request.Files;
                //int i = 1;
                UploadedFileCollection fileCollection = new UploadedFileCollection();
                //setting the files to session
                if (Session["FilesUploaded"] == null)
                {
                    fileCollection.Files = new System.Collections.Generic.List<UploadedFile>();
                    Session["FilesUploaded"] = fileCollection.Files;
                }
                else
                {
                    fileCollection.Files = (System.Collections.Generic.List<UploadedFile>)(Session["FilesUploaded"]);
                }
                CreateProgress(UploadedFiles);
                for (int i = 0; i < UploadedFiles.Count; i++)
                {
                    string strFileName = System.IO.Path.GetFileName(UploadedFiles[i].FileName);
                    string strFileSize = UploadedFiles[i].ContentLength.ToString();
                    string strFileContent = UploadedFiles[i].ContentType;
                    DownloadTheFileToServer(UploadedFiles[i], i);
                    fileCollection.Files.Add(new UploadedFile { FileName = strFileName, FileSize = strFileSize, FileContentType = strFileContent });
                }
                RemoveProgress();
                Session["FilesUploaded"] = fileCollection.Files;
                this.GridView1.DataSource = fileCollection.Files;
                this.GridView1.DataBind();
            }



            catch (Exception ex)
            {

                Response.Write(ex.Message);

            }

        }
        /// <summary>
        /// Downloads the file to the local server, pa
        /// </summary>
        /// <param name="file"></param>
        /// <param name="id"></param>
        public void DownloadTheFileToServer(HttpPostedFile file, int id)
        {
            Stream stream = null;
            FileStream fs = null;

            #region File Download Code goes here
            try
            {
                
                string strFileName = System.IO.Path.GetFileName(file.FileName);
                int contentLength = file.ContentLength;
                stream = file.InputStream;
                long totalUploadSize = stream.Length;
                int bufferSize = 0;
                //less than 1kB
                if (totalUploadSize <= 1024)
                {
                    bufferSize = 1024;
                }
                //less than 4kB but more than 1kB
                else if (bufferSize <= 4096)
                {
                    bufferSize = 4096;
                }
                //less than 8Kb
                else if (bufferSize <=8192)
                {
                    bufferSize = 8192;
                }
                else
                {
                    bufferSize = 16384;
                }

                byte[] b = new byte[1024];
                int tripDownloadSize = 0;
                long totalDownloadedSize = 0;
                float Percentage = 0;
                bool isNewFile = true;
                string fileStoreLocation = ConfigurationManager.AppSettings["FileStoreLocation"];
                fs = new FileStream(fileStoreLocation + strFileName, FileMode.Append);

                //Uplaods 8Kb at a time
                while ((tripDownloadSize = stream.Read(b, 0, 1024)) > 0)
                {
                    fs.Write(b, 0, tripDownloadSize);
                    totalDownloadedSize += tripDownloadSize;
                    Percentage = (int)(totalDownloadedSize * 100) / totalUploadSize;
                    setProgressBar(id, Percentage.ToString());
                    System.Threading.Thread.Sleep(100);
                    isNewFile = false;
                }

                

            }
            catch (Exception objException)
            {
                throw objException;
            }
            finally
            {
                if (stream != null)
                {
                    stream.Close();
                    stream.Dispose();
                }
                if (fs != null)
                {
                    fs.Close();
                    fs.Dispose();
                }
            }
            #endregion
        }

        protected void Page_Load(object sender, EventArgs e)
        {

        }

    }
}