﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Web_PDFConverter
{
    public partial class _Default : System.Web.UI.Page
    {
        private PDFConverter.RemoteConverter converter;

        //set your "working folder" here:
        private string storefolder = @"D:\PDFConverter\";

        protected void Page_Load(object sender, EventArgs e)
        {
            try
            {
                //try to get the remoting-object
                converter=(PDFConverter.RemoteConverter)Activator.GetObject(typeof(PDFConverter.RemoteConverter),"http://localhost:8989/RemoteConverter");
            
                if(!converter.WordIsAvailable())
                {
                    lbl_error.Text = "Word 2007 not available on server!";
                    FileUpload1.Visible = false;
                    btn_convert.Visible = false;
                }

            }catch
            {
                //Remoteserver not available
                lbl_error.Text = "PDFConverter is not running!";
                FileUpload1.Visible = false;
                btn_convert.Visible = false;
            }
        }

        protected void btn_convert_Click(object sender, EventArgs e)
        {
            if (FileUpload1.HasFile)
            {
                if (FileUpload1.FileName.Contains(".doc"))
                {
                    string sourcefile = storefolder + FileUpload1.FileName;
                    string outputfile = storefolder + FileUpload1.FileName.Replace(".doc", ".pdf");
                    
                    //Save original file
                    FileUpload1.SaveAs(sourcefile);
                    
                  
                    //call the converter method
                    converter.convert(sourcefile, outputfile);

                    //delete the original file
                    if (System.IO.File.Exists(sourcefile))
                        System.IO.File.Delete(sourcefile);


                        //Send back a downloadable File
                        System.IO.FileInfo downloadFile = new System.IO.FileInfo(outputfile);
                        HttpContext.Current.Response.Clear();
                        HttpContext.Current.Response.ContentType = "application/pdf";
                        HttpContext.Current.Response.AddHeader("Content-Disposition",
                                                               string.Format("attachment; filename={0}",
                                                                             downloadFile.Name));
                        HttpContext.Current.Response.AddHeader("Content-Length", downloadFile.Length.ToString());
                        HttpContext.Current.Response.WriteFile(downloadFile.FullName);
                        HttpContext.Current.Response.End();
                        HttpContext.Current.Response.Close();

                        //be warned: at this point, the pdf-file is still existing in the storefolder.
                        //as we don't know how long it takes for the user, to download the file, we can not
                        //delete the pdf file at this point.

                    }
                }
                else
                {
                    lbl_error.Text = "Only Word-Files can be converted!";
                }
            }
        }
}
