using System;
using System.Data;
using System.Data.OleDb;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class _Default : System.Web.UI.Page 
{
    DataTable CSVTable;
    protected void Page_Load(object sender, EventArgs e)
    {

    }
     
    //to display remote csv file
    protected void btnDispRemote_Click(object sender, EventArgs e)
    {
        try
        {
            System.Net.HttpWebRequest WebRequest;
            string URL = txtRemote.Text.Trim(); //URL of the remote csv
            Uri CSVUri = new Uri(URL);

            WebRequest = (System.Net.HttpWebRequest)System.Net.HttpWebRequest.Create(CSVUri);
            if ((WebRequest.GetResponse().ContentLength > 0))
            {
                System.IO.StreamReader strReader = new System.IO.StreamReader(WebRequest.GetResponse().GetResponseStream());
                
                CreateCSVTable(strReader.ReadLine());   //create datatable with column names
                String SingleLine;
                while ((SingleLine = strReader.ReadLine()) != null)
                {
                    AddRowCSVTable(SingleLine); //adding rows to datatable
                }

                grdList.DataSource = CSVTable;
                grdList.DataBind();

                if (strReader != null) strReader.Close();
            }
        }
        catch (System.Net.WebException ex)
        {
            lblMsg.Text = "File does not exist.";
        }
    }

    //to display local csv file
    protected void btnDispLoc_Click(object sender, EventArgs e)
    {
        string filename=fl.PostedFile.FileName.ToString();
        FileInfo file = new FileInfo(filename);
        string ConnectionString = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=\"" + file.DirectoryName + "\";Extended Properties='text;HDR=Yes;FMT=Delimited(,)';";
        OleDbConnection con = new OleDbConnection(ConnectionString);
        OleDbCommand cmd = new OleDbCommand(string.Format("SELECT * FROM [" + file.Name + "]", file.Name), con);
        try
        {
            con.Open();
            OleDbDataAdapter oda = new OleDbDataAdapter(cmd);
            DataTable dt = new DataTable("CSVTable");
            oda.Fill(dt);
            grdList.DataSource = dt;
            grdList.DataBind();
        }
        catch (Exception ee)
        {
            lblMsg.Text = ee.Message;
        }
      
    }

    //to create the data table with columns
    public void CreateCSVTable(string TableColumnList)
    {
        CSVTable = new DataTable("CSVTable");
        DataColumn myDataColumn;
        string[] ColumnName = TableColumnList.Split(',');
        for (int i = 0; i < ColumnName.Length - 1; i++)
        {
            myDataColumn = new DataColumn();
            myDataColumn.DataType = Type.GetType("System.String");
            myDataColumn.ColumnName = ColumnName[i];
            CSVTable.Columns.Add(myDataColumn);
        }
    }

    //to add the rows to datatable
    public void AddRowCSVTable(string RowValueList)
    {
        string[] RowValue = RowValueList.Split(',');
        DataRow myDataRow;
        myDataRow = CSVTable.NewRow();
        for (int i = 0; i < RowValue.Length - 1; i++)
        {
            myDataRow[i] = RowValue[i];
        }
        CSVTable.Rows.Add(myDataRow);
    }

}
