<%@ Page language="c#" Codebehind="Default.aspx.cs" AutoEventWireup="false" Inherits="AJAXUpload._Default" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Default</title>
		<meta content="Microsoft Visual Studio .NET 7.1" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<style type="text/css"> .tdBorder { border-color:Black; border-width:1px; border-style:Solid; }
	.tableBorder { border-color:Black; border-width:1px; border-style:Solid; border-collapse:collapse; }
		</style>
		<script language="javascript">
		var filePath;
		var xmlhttp;
		var fileSize;
		var fileName;
		var adoStream = new ActiveXObject("ADODB.Stream");
		var cancelUpload;
		
		//Receive intial file information and init upload
		function getFileParams()
		{ 
			//Convert file path to appropriate format
			this.filePath = document.getElementById("file").value.replace(/\\/g, "\\\\");
			
			fso = new ActiveXObject( 'Scripting.FileSystemObject' );
			if ( !fso.FileExists(this.filePath) )
			{
				alert("Can't open file.");
				return;
			}
				
			f = fso.GetFile( this.filePath );
			this.fileSize = f.size;
			this.fileName = f.Name;
			InitStatusForm();
			InitUpload();
		}
		//Initialize progress bar panel
		function InitStatusForm()
		{
				this.cancelUpload = false;
				SetButtonCloseState(true);
				document.getElementById("uploadStatus").innerHTML = "Initializing";
				document.getElementById("fileSize").innerHTML = (this.fileSize/1024).toLocaleString();
				document.getElementById("uploadPercentage").innerHTML = "0".toLocaleString();
				document.getElementById("progressBar").style.width = 0+"%";
		}
		//Read part of file and send it to webservice
		function SendFilePart(offset, length)
		{
			// create SOAP XML document
			var xmlSOAP = new ActiveXObject("MSXML2.DOMDocument");
			xmlSOAP.loadXML('<?xml version="1.0" encoding="utf-8"?>'+
			'<soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">'+
				'<soap:Body>'+
					'<UploadData xmlns="http://tempuri.org/">'+
						'<fileName>'+this.fileName+'</fileName>'+
						'<fileSize>'+this.fileSize+'</fileSize>'+
						'<file></file>'+
					'</UploadData>'+
				'</soap:Body>'+
			'</soap:Envelope>');
			
			// create a new node and set binary content
			var fileNode = xmlSOAP.selectSingleNode("//file");
			fileNode.dataType = "bin.base64";
			// open stream object and read source file
			if (adoStream.State != 1 )
			{
				adoStream.Type = 1;  // 1=adTypeBinary 
				adoStream.Open(); 
				adoStream.LoadFromFile(this.filePath);
			}
			
			adoStream.Position = offset;
			// store file content into XML node
			fileNode.nodeTypedValue = adoStream.Read(length);//adoStream.Read(-1); // -1=adReadAll
			if (adoStream.EOS)
			{
				//Close Stream
				adoStream.Close();
			}
			
			// send XML document to Web server
			xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
			xmlhttp.onreadystatechange = HandleStateChange;
			xmlhttp.open("POST","http://localhost/AJAXUpload/Upload.asmx",true);
			xmlhttp.setRequestHeader("SOAPAction", "http://tempuri.org/UploadData");
			xmlhttp.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
			xmlhttp.send(xmlSOAP);
		}
		//send init upload request to webservice
		function InitUpload()
		{
			document.getElementById("uploadConsole").style.display = "none";
			document.getElementById("statusConsole").style.display = "block";
			
			xmlhttp = new ActiveXObject( "Microsoft.XMLHTTP" );
			xmlhttp.onreadystatechange = HandleStateChange;
		
			var parameters = "fileSize=" + encodeURI(this.fileSize) +
			"&fileName=" + encodeURI(this.fileName)+
			"&overwriteFile=" + encodeURI(document.getElementById("overwriteFile").checked);

			xmlhttp.open("POST","http://localhost/AJAXUpload/Upload.asmx/InitUpload", true);
			xmlhttp.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xmlhttp.setRequestHeader("Content-length", parameters.length);
			xmlhttp.setRequestHeader("Connection", "close");
			xmlhttp.send(parameters);
		}
		//XMLHTTPRequest change state callback function
		function HandleStateChange() {
			switch (xmlhttp.readyState) {
			case 4:
				response  = xmlhttp.responseXML.documentElement;
				id = response.getElementsByTagName('ID')[0].firstChild.data;
				offset = response.getElementsByTagName('OffSet')[0].firstChild.data;
				bufferLength = response.getElementsByTagName('BufferLength')[0].firstChild.data;
				
				percentage = (offset/this.fileSize)*100;
				if (offset<this.fileSize && !this.cancelUpload)
				{
					UpdateStatusConsole(percentage, "Uploading");
					SendFilePart(offset, bufferLength);
				}
				else
				{
					SetButtonCloseState(false);
					if (this.cancelUpload)
						UpdateStatusConsole(percentage, "Canceled");
					else
						UpdateStatusConsole(percentage, "Complete");
				}
				break;
			}	
		}
		//Update progress bar panel
		function UpdateStatusConsole(percentage, uploadStatus)
		{
			document.getElementById("uploadPercentage").innerHTML = percentage.toLocaleString();
			document.getElementById("progressBar").style.width = percentage+"%";
			document.getElementById("uploadStatus").innerHTML = uploadStatus;
		}
		//Encode parameter
		function URLEncode(str) 
		{
			return escape(str).replace(/[+]/g, '%2B');
		}
		//Close button functionality
		function CancelUpload()
		{
			this.cancelUpload = true;
			SetButtonCloseState(false);
		}
		//Set close button Enabled/Disabled state
		function SetButtonCloseState(disabled)
		{
			document.getElementById("buttonClose").disabled = disabled;
		}
		//Hide Progress bar panel and set panel with brose file dialog visible
		function CloseStatusConsole()
		{
			document.getElementById("uploadConsole").style.display = "block";
			document.getElementById("statusConsole").style.display = "none";
		}
		</script>
	</HEAD>
	<body>
		<form id="Form1" method="post" runat="server">
			<TABLE class="tableBorder" id="statusConsole" cellSpacing="0" cellPadding="0" width="360"
				bgColor="ghostwhite" border="0" style="DISPLAY: none">
				<TR bgColor="gainsboro">
					<TD align="center" width="350" bgColor="gainsboro" colSpan="3">Status: <span id="uploadStatus">
							Initializing</span></TD>
					<TD align="right" width="10"><INPUT type="button" id="buttonClose" value="X" disabled onclick="CloseStatusConsole();"></TD>
				</TR>
				<TR>
					<TD width="50"></TD>
					<TD align="center" width="250">File Size: <span id="fileSize">1,234,321</span> KB</TD>
					<TD width="50"></TD>
					<TD width="10"></TD>
				</TR>
				<TR>
					<TD align="right" width="50">0%</TD>
					<TD class="tdBorder" width="250">
						<TABLE id="progressBar" height="20" cellSpacing="0" cellPadding="0" width="50%" bgColor="dimgray"
							border="0">
							<TR>
								<TD></TD>
							</TR>
						</TABLE>
					</TD>
					<TD width="50">100%</TD>
					<TD width="10"></TD>
				</TR>
				<TR>
					<TD width="50"></TD>
					<TD align="center" width="250">Uploaded: <span id="uploadPercentage">25.20</span> %</TD>
					<TD width="50"></TD>
					<TD width="10"></TD>
				</TR>
				<TR>
					<TD width="50"></TD>
					<TD align="center" width="250"><INPUT id="buttonCancel" type="button" value="Cancel" onclick="CancelUpload();"></TD>
					<TD width="50"></TD>
					<TD width="10"></TD>
				</TR>
				<TR>
					<TD width="50"></TD>
					<TD align="center" width="250">&nbsp;</TD>
					<TD width="50"></TD>
					<TD width="10"></TD>
				</TR>
			</TABLE>
			<TABLE class="tableBorder" id="uploadConsole" borderColor="black" cellSpacing="0" cellPadding="1"
				width="360" bgColor="ghostwhite" border="0">
				<TR>
					<TD class="tdBorder" align="center" bgColor="gainsboro" colSpan="2">Upload Console</TD>
				</TR>
				<TR>
					<TD class="tdBorder" align="center" width="300">File Path</TD>
					<TD class="tdBorder" width="60">Overwrite</TD>
				</TR>
				<TR>
					<TD class="tdBorder" align="center" width="300"><INPUT id="file" type="file" name="file"></TD>
					<TD class="tdBorder" align="center" width="60"><INPUT id="overwriteFile" type="checkbox" value="on"></TD>
				</TR>
				<TR>
					<TD class="tdBorder" align="right" colSpan="2"><INPUT id="ButtonUpload" onclick="getFileParams(); return false;" type="button" value="Upload"
							name="ButtonUpload"></TD>
				</TR>
			</TABLE>
		</form>
	</body>
</HTML>
