﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using System.IO;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
       
        string p = Request["start"];
        if (p == null || p.IndexOf(rootPath) < 0)
            startpath = rootPath;
        else
            startpath = p;

        if (!IsPostBack)
        {
            string w = Request["goto"];
            if (w == null)
                ViewList();
            else
            {
                switch (w)
                {
                    case "addnew":
                        MultiView1.SetActiveView(View1);
                        Label4.Text = "Create Text File";
                        //TextBox1.Text = "";
                        TextBox1.ReadOnly = false;
                        Button7.Visible = false;
                        break;
                    case "addnew2":
                        MultiView1.SetActiveView(View1);
                        Label4.Text = "Create Text File";
                        //TextBox1.Text = "";
                        TextBox1.ReadOnly = false;
                        Button7.Visible = true;
                        break;
                    case "listview":
                        ViewList();
                        break;
                    case "edit":
                        editThisfile();
                        break;
                    case "ren":
                        renamethisfile();
                        break;
                    case "del":
                        deleteThisfile();
                        break;
                    case "info":
                        information();
                        break;
                    case "link":
                        showlink();
                        break;
                    case "newFolder":
                        MultiView1.SetActiveView(View7);
                        break;
                    case "Upload":
                        MultiView1.SetActiveView(View8);
                        break;
                    case "zip":
                        CreateZip();
                        break;
                    case "AddZip":
                        AddtoZip();
                        break;
                    case "RemoveZip":
                        RemoveZip();
                        break;
                    case "ReloadZip":
                        ReloadZip();
                        break;
                    case "DeletArch":
                        DeletArch();
                        break;
                    default:
                        break;
                }
            }
        }
    }
    protected string rootPath = "otherfile";
    private void DeletArch()
    {
        if (ziplist != null || ziplist.Count > 0)
        {
            Table4.Rows.Clear();
            Table4.Attributes.Add("dir", "ltr");
            Table4.Style.Add("text-align", "left");
            TableRow tr = new TableRow();
            MyTableCell mtc = new MyTableCell(ziplist.Count.ToString());
            tr.Cells.Add(mtc);
            foreach (string f in ziplist)
            {
                tr = new TableRow();
                mtc = new MyTableCell(f);
                tr.Cells.Add(mtc);
                Table4.Rows.Add(tr);
            }
            Label5.Text = "Are you sure delete this files?";
            Button2.Visible = false;
            Button15.Visible = true;
            MultiView1.SetActiveView(View3);
        }
        else
            ViewList();
        /* */
    }

    private void ReloadZip()
    {
        if (ziplist != null || ziplist.Count > 0)
            ziplist.Clear();
        ViewList();
    }

    private void RemoveZip()
    {
        if (ziplist != null || ziplist.Count > 0)
            ziplist.Remove(startpath + "\\" + Request["thisfile"]);
        ViewList();
    }

    private void AddtoZip()
    {
        if (ziplist == null)
            ziplist = new List<string>();
        ziplist.Add(startpath + "\\" + Request["thisfile"]);
        ViewList();
    }

    private string startpath;
    private static List<string> ziplist;
    private void CreateZip()
    {
        Table3.Rows.Clear();
        Table3.Style.Add("text-align", "left");
        TableRow tr = new TableRow();
        MyTableCell mtc = new MyTableCell(ziplist.Count.ToString());
        tr.Cells.Add(mtc);
        foreach (string f in ziplist)
        {
            tr = new TableRow();
            mtc = new MyTableCell(f);
            tr.Cells.Add(mtc);
            Table3.Rows.Add(tr);
        }
        MultiView1.SetActiveView(View9);
    }
    private void showlink()
    {


        Label2.Text = startpath + "/" + Request["thisfile"];
        HtmlLink hl = new HtmlLink();
        hl.Href = startpath + "/" + Request["thisfile"];
        Label3.Text = "http://" + Request.Url.Host + "/" + startpath.Replace("\\", "/") + "/" + Request["thisfile"];
        MultiView1.SetActiveView(View5);
    }

    private void information()
    {
        string p = Server.MapPath(startpath + "\\" + Request["thisfile"]);
        FileInfo fi = new FileInfo(p);
        if (fi.Attributes == FileAttributes.Directory)
            return;
        Table2.Rows.Clear();
        TableCell tc = new TableCell();
        Image im = new Image();
        string ex = fi.Extension;
        if (ex == ".gif" || ex == ".jpg" || ex == ".jpeg" || ex == ".png")
        {
            im.ImageUrl = startpath + "/" + Request["thisfile"];
            if (im.Width.Value > 128)
                im.Width = new Unit("128px");
            if (im.Height.Value > 128)
                im.Height = new Unit("128px");
        }
        else
            im.ImageUrl = getmimetype(fi.Extension).Replace("mimetype", "bigmimetype");
        tc.Controls.Add(im);
        TableRow tr = new TableRow();
        tc.ColumnSpan = 2;
        tr.Cells.Add(tc);
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("File type"), new MyTableCell(getmimetypename(fi.Extension)) });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("File name"), new MyTableCell(fi.Name) });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Size"), new MyTableCell(fi.Length.ToString() + " byte", "date-style") });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Last write Time"), new MyTableCell(fi.LastWriteTime.ToShortDateString(), "date-style") });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Last Access Time"), new MyTableCell(fi.LastAccessTime.ToShortDateString(), "date-style") });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Creation Time"), new MyTableCell(fi.CreationTime.ToShortDateString(), "date-style") });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("IsReadOnly"), new MyTableCell(fi.IsReadOnly.ToString()) });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Attributes"), new MyTableCell(fi.Attributes.ToString()) });
        Table2.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new MyTableCell[] { new MyTableCell("Download Link"), 
            new MyTableCell("<a href='"+startpath+"\\"+fi.Name+"'>"+fi.Name+"</a>") });
        Table2.Rows.Add(tr);

        MultiView1.SetActiveView(View6);
    }

    private void deleteThisfile()
    {
        //throw new Exception("The method or operation is not implemented.");
        Label5.Text = "Are you sure Delete " + Request["thisfile"] + "?";

        Button15.Visible = false;
        Button2.Visible = true;
        MultiView1.SetActiveView(View3);
    }

    private void renamethisfile()
    {
        TextBox2.Text = Request["thisfile"];
        MultiView1.SetActiveView(View4);
    }

    private void editThisfile()
    {
        TextBox1.ReadOnly = true;
        TextBox1.Text = Request["thisfile"];
        string buf = "";
        try
        {
            StreamReader sr = System.IO.File.OpenText(Server.MapPath(startpath + "\\" + TextBox1.Text));
            buf = sr.ReadToEnd();
            sr.Close();
        }
        catch (Exception ex)
        {
            Label1.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        elm1.Value = buf;
       // HtmlEditor1.Text = buf;
        Label4.Text = "Edit Text File";
        MultiView1.SetActiveView(View1);
        Button7.Visible = true;
    }

    private void ViewList()
    {
        string p = Server.MapPath(startpath);
        if (!Directory.Exists(p))
        {
            MultiView1.SetActiveView(View2);
            return;
        }
        string[] fns = Directory.GetFiles(p);
        string[] dns = Directory.GetDirectories(p);
        string uplevel = startpath;
        if (uplevel.LastIndexOf("\\") > 0)
            uplevel = uplevel.Substring(0, uplevel.LastIndexOf("\\"));
        Table1.Rows.Clear();
        Table1.CssClass = "ms-list8-main";
        TableRow tr = new TableRow();
        MyTableCell head = new MyTableCell("ms-list8-top", new MyImageButton("softimages/folder_home.png", "Default.aspx?goto=listview", "Root")
            , new MyImageButton("softimages/back.png", "Default.aspx?goto=listview&start=" + uplevel, "Back")
            , new MyImageButton("softimages/top.png", "Default.aspx?goto=Upload&start=" + startpath, "Upload File")
            , new MyImageButton("softimages/newfolder.png", "Default.aspx?goto=newFolder&start=" + startpath, "New Folder")
            , new MyImageButton("softimages/mimetype/html.png", "Default.aspx?goto=addnew2&start=" + startpath, "New Text File")
            , new MyImageButton("softimages/ark.png", "Default.aspx?goto=zip&start=" + startpath, "Archive")
            , new MyImageButton("softimages/reloadark.png", "Default.aspx?goto=ReloadZip&start=" + startpath, "Clear Archive")
            //, new MyImageButton("softimages/bottom.png", "Default.aspx?goto=download&start=" + startpath, "Download")
            , new MyImageButton("softimages/delark.png", "Default.aspx?goto=DeletArch&start=" + startpath, "Delete Archive"));
        head.ColumnSpan = 5;
        tr.Cells.Add(head);
        Table1.Rows.Add(tr);
        tr = new TableRow();
        tr.Cells.AddRange(new TableCell[] {new MyTableCell("File Name","ms-list8-tl"),new MyTableCell("Size","ms-list8-top")
            ,new MyTableCell("Creation Time","ms-list8-top"),
         new MyTableCell("Last write time","ms-list8-top") ,new MyTableCell("Commands","ms-list8-top")});
        Table1.Rows.Add(tr);
        PrintList(dns, false);
        PrintList(fns, true);
        tr = new TableRow();
        MyTableCell mtc = new MyTableCell("&nbsp;", "ms-list8-bottom");
        mtc.ColumnSpan = 5;
        tr.Cells.Add(mtc);
        Table1.Rows.Add(tr);
        MultiView1.SetActiveView(View2);
    }
    private void PrintList(string[] fns, bool isfiles)
    {
        try
        {
            int i = 1;
            string c = "";
            //sm.RegisterAsyncPostBackControl(Label6);
            FileInfo fi = null;
            DirectoryInfo di = null;
            foreach (string fn in fns)
            {
                if (isfiles)
                    fi = new FileInfo(fn);
                else
                    di = new DirectoryInfo(fn);
                TableRow tr = new TableRow();
                if (i % 2 == 0)
                    c = "odd";
                else
                    c = "even";
                bool havedit;
                string ext;
                if (isfiles)
                {

                    if (fi.Extension == ".htm" || fi.Extension == ".html" || fi.Extension == ".txt"
                        || fi.Extension == ".js" || fi.Extension == ".java" || fi.Extension == ".php"
                        || fi.Extension == ".css")
                        havedit = true;
                    else
                        havedit = false;
                    ext = fi.Extension;
                }
                else
                {
                    havedit = false;
                    ext = "directory";
                }
                string name = ((isfiles) ? fi.Name : di.Name);
                MyLinkButton li = new MyLinkButton(name, getmimetype(ext));
                li.CssClass = "filename";
                MyImageButton zipBut;
                if (ext != "directory")
                {
                    li.Url = "Default.aspx?goto=info&thisfile=" + name + "&start=" + startpath;
                    if (ziplist == null || ziplist.Count <= 0 || !ziplist.Contains(startpath + "\\" + name))
                        zipBut = new MyImageButton("softimages/addzip.png",
                            "Default.aspx?goto=AddZip&thisfile=" + name + "&start=" + startpath, "Add to archive");
                    else //if (ziplist.Contains(startpath + "\\" + fi.Name))
                        zipBut = new MyImageButton("softimages/removezip.png",
                            "Default.aspx?goto=RemoveZip&thisfile=" + name + "&start=" + startpath, "Remove from archive");

                }
                else
                {
                    li.Url = "Default.aspx?goto=listview&start=" + startpath + "\\" + di.Name;
                    zipBut = new MyImageButton("softimages/diszip.png", "", "");

                }

                tr.Cells.AddRange(new TableCell[] {new MyTableCell("ms-list8-left", li),
                new MyTableCell((ext!="directory")?fi.Length.ToString():"-","ms-list8-"+c),
                new MyTableCell(((isfiles)?fi.CreationTime.ToString():di.CreationTime.ToString()),"ms-list8-"+c),
                new MyTableCell(((isfiles)?fi.LastWriteTime.ToString():di.LastWriteTime.ToString()),"ms-list8-"+c) ,
                new MyTableCell("ms-list8-"+c,GetButtons(name,havedit,zipBut))});
                Table1.Rows.Add(tr);
                i++;
            }
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
    }

    private string getmimetypename(string p)
    {
        switch (p)
        {
            case ".htm":
            case ".html":
                return "Hyper Text Markup Language";
            case ".java":
            case ".js":
            case ".class":
            case ".jar":
                return "Java File";
            case ".css":
                return "Style sheet";
            case ".zip":
            case ".rar":
            case ".tar":
            case ".gz":
            case ".7z":
            case ".bz2":
            case ".cab":
                return "Archive";
            case ".php":
                return "PHP";
            case ".txt":
                return "Text";
            case ".doc":
            case ".rtf":
                return "Complex Text";
            case ".pdf":
                return "Electronic text";
            case ".jpg":
            case ".gif":
            case "jpeg":
            case ".png":
            case ".tiff":
                return "Image";
            case ".tex":
                return "Tex";
            case "directory":
                return "Directory";
            default:
                return "Undefined" + p;
        }
    }
    private string getmimetype(string p)
    {
        switch (p)
        {
            case ".htm":
            case ".html":
                return "~\\softimages\\mimetype\\html.png";
            case ".java":
            case ".js":
            case ".class":
            case ".jar":
                return "~\\softimages\\mimetype\\java_jar.png";
            case ".css":
                return "~\\softimages\\mimetype\\css.png";
            case ".zip":
            case ".rar":
            case ".tar":
            case ".gz":
            case ".7z":
            case ".bz2":
            case ".cab":
                return "~\\softimages\\mimetype\\tar.png";
            case ".php":
                return "~\\softimages\\mimetype\\php.png";
            case ".txt":
                return "~\\softimages\\mimetype\\txt.png";
            case ".doc":
            case ".rtf":
                return "~\\softimages\\mimetype\\word.png";
            case ".pdf":
                return "~\\softimages\\mimetype\\pdf.png";
            case ".jpg":
            case ".gif":
            case "jpeg":
            case ".png":
            case "tiff":
                return "~\\softimages\\mimetype\\image.png";
            case ".tex":
                return "~\\softimages\\mimetype\\tex.png";
            case "directory":
                return "~\\softimages\\mimetype\\folder.png";
            default:
                return "~\\softimages\\mimetype\\mime.png";
        }
    }
    private MyImageButton[] GetButtons(string f, bool havedit, MyImageButton otherControl)
    {
        List<MyImageButton> li = new List<MyImageButton>();
        if (havedit)
            li.Add(new MyImageButton("softimages/pencil.png", "Default.aspx?goto=edit&thisfile=" + f + "&start=" + startpath, "Edit"));
        else
            li.Add(new MyImageButton("softimages/misc.png", "", "Cant Edit"));
        li.Add(new MyImageButton("softimages/browser.png", "Default.aspx?goto=link&thisfile=" + f + "&start=" + startpath, "Links"));
        li.Add(new MyImageButton("softimages/messagebox_critical.png", "Default.aspx?goto=del&thisfile=" + f + "&start=" + startpath, "Delete"));
        li.Add(new MyImageButton("softimages/rename.png", "Default.aspx?goto=ren&thisfile=" + f + "&start=" + startpath, "Rename"));
        li.Add(otherControl);
        return li.ToArray();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        string p = Server.MapPath(startpath);
        try
        {
            if (!Directory.Exists(p))
                Directory.CreateDirectory(p);
            string fn = TextBox1.Text;
            StreamWriter sw = System.IO.File.CreateText(p + "\\" + fn);            
            sw.Write(elm1.Value);//HtmlEditor1.Text);
            sw.Close();
            Label1.ForeColor = System.Drawing.Color.Green;
            Label1.Text = "File Saved.";
        }
        catch (Exception ex)
        {
            Label1.ForeColor = System.Drawing.Color.Red;
            Label1.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        try
        {
            string thisfile = Request["thisfile"];
            string p = Server.MapPath(startpath + "\\" + thisfile);
            if (CheckBox1.Checked)
            {
                FileInfo fi = new FileInfo(p);
                if (fi.Attributes != FileAttributes.Directory)
                    System.IO.File.Delete(p);
                else
                    Directory.Delete(p);
                Label6.Text = "removed Successfuly";
            }
            else
                Label6.Text = "For Delete you must select yes!";
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }

    }
    protected void Button3_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button4_Click(object sender, EventArgs e)
    {
        try
        {

            string oldname = Server.MapPath(startpath + "\\" + Request["thisfile"]);
            string newName = Server.MapPath(startpath + "\\" + TextBox2.Text);
            FileInfo fi = new FileInfo(oldname);
            DirectoryInfo di = new DirectoryInfo(oldname);
            if (fi.Attributes != FileAttributes.Directory)
                System.IO.File.Move(oldname, newName);
            else
                Directory.Move(oldname, newName);
            //File.Copy(oldname, newName, true);            
            // File.Delete(oldname);
            Label6.Text = " Rename successfuly";

        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }
    }
    protected void Button5_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button7_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button8_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button6_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button9_Click(object sender, EventArgs e)
    {
        try
        {
            string p = Server.MapPath(startpath + "\\" + TextBox3.Text);
            Directory.CreateDirectory(p);
            Label6.Text = "Create folder successfuly";
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }
    }
    protected void Button10_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button12_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button11_Click(object sender, EventArgs e)
    {
        try
        {
            SaveFile(FileUpload1, CheckBox2.Checked);
            SaveFile(FileUpload2, CheckBox3.Checked);
            SaveFile(FileUpload3, CheckBox4.Checked);
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }
    }

    private void SaveFile(FileUpload FU, bool isZip)
    {
        //first save file in tmp
        //then if zip file decompress in to startup folder
        // else copy in startup folder
        try
        {
            string tmp = Server.MapPath("tmp");
            string dest = Server.MapPath(startpath);
            if (!Directory.Exists(tmp))
                Directory.CreateDirectory(tmp);
            if (!FU.HasFile)
                return;
            string tmpf = tmp + "\\" + FU.FileName;
            FU.SaveAs(tmpf);
            if (!isZip)
                System.IO.File.Move(tmpf, dest + "\\" + FU.FileName);
            else
            {
                //MyZip.UnZip(tmpf, dest);
                Gchip.ZipClass.zip z = new Gchip.ZipClass.zip();
                z.AfterOpen += new EventHandler(z_AfterOpen);
                fine = false;
                z.OpenZip(tmpf, dest);
                Wait();
                File.Delete(tmpf);
            }
            Label6.Text = "Upload successfuly";
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }

    }
    private bool fine;
    private void Wait()
    {
        while (!fine)
        {
            //do wait
        }
    }

    void z_AfterOpen(object sender, EventArgs e)
    {
        fine = true;
    }

    protected void Button14_Click(object sender, EventArgs e)
    {
        ViewList();
    }
    protected void Button13_Click(object sender, EventArgs e)
    {
        try
        {
            String[] s = new string[ziplist.Count];
            int i = 0;
            foreach (string sf in ziplist)
            {
                s[i] = Server.MapPath(sf);
                i++;
            }
            string zipname = (!CheckBox6.Checked ? startpath + "\\" : rootPath+"\\") + TextBox4.Text;
            zipname = Server.MapPath(zipname);
            //MyZip.Zip(zipname, s);
            //first must create a directory for this user
            string tmpthisUser = Server.MapPath(rootPath+"/tmp" + Session.SessionID);
            if (!Directory.Exists(tmpthisUser))
                Directory.CreateDirectory(tmpthisUser);
            //Now Copy files in list to this folder
            i = 0;
            List<string> tmpfile = new List<string>();
            foreach (string file in s)
            {
                FileInfo fi = new FileInfo(file);
                string tf = tmpthisUser + "\\" + fi.Name;
                tmpfile.Add(tf);
                File.Copy(file, tf);
                i++;
            }

            Gchip.ZipClass.zip z = new Gchip.ZipClass.zip();
            fine = false;
            z.AfterCreate += new EventHandler(z_AfterCreate);
            z.CreateZip(tmpthisUser, zipname);
            Wait();
            //first we must Empty Directory
            foreach (string file in tmpfile)
            {
                File.Delete(file);
            }
            Directory.Delete(tmpthisUser);
            if (CheckBox5.Checked)
                ziplist.Clear();
            Label6.Text = "Archive create successfuly";
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }
    }

    void z_AfterCreate(object sender, EventArgs e)
    {
        fine = true;
    }
    protected void Button15_Click(object sender, EventArgs e)
    {

        try
        {
            if ((ziplist != null || ziplist.Count > 0) && CheckBox1.Checked)
            {
                String[] s = new string[ziplist.Count];
                int i = 0;
                foreach (string sf in ziplist)
                {
                    s[i] = Server.MapPath(sf);
                    i++;
                }
                for (i = 0; i < s.Length; i++)
                {
                    File.Delete(s[i]);
                }
                ziplist.Clear();
            }
        }
        catch (Exception ex)
        {
            Label6.Text = ex.Message;
            DrWatson.SaveError(ex);
        }
        finally
        {
            ViewList();
        }
    }   
}
