using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.Compilation;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net.Mail;
using System.Collections.Specialized;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Xml.Serialization;
using WebConfig = System.Web.Configuration;

namespace Elsinore.Website
{
	public static class Utility
	{
		public static string GetHandlerPath(Type type)
		{
			WebConfig.HttpHandlersSection httpHandlersSection = (WebConfig.HttpHandlersSection)WebConfig.WebConfigurationManager.GetSection("system.web/httpHandlers");

			foreach (WebConfig.HttpHandlerAction httpHandlerAction in httpHandlersSection.Handlers)
			{
				Type httpHandlerActionType = BuildManager.GetType(httpHandlerAction.Type, true);
				
				if (type.IsAssignableFrom(httpHandlerActionType))
				{
					return httpHandlerAction.Path;
				}
			}

			string message = string.Format("No HTTP handler defined for '{0}'.", type);
			throw new InvalidOperationException(message);
		}

		public static string GetUrl(string baseUrl, NameValueCollection parameters)
		{
			return baseUrl + "?" + UrlEncode(parameters);
		}

		public static string GetUrl(string baseUrl, string param1Name, object param1Value)
		{
			NameValueCollection nvc = new NameValueCollection(1);
			nvc.Add(param1Name, param1Value == null ? null : param1Value.ToString());

			return GetUrl(baseUrl, nvc);
		}

		public static string UrlEncode(NameValueCollection parameters)
		{
			StringBuilder stringBuilder = new StringBuilder();
			bool first = true;
			foreach (string parameter in parameters)
			{
				if (first)
				{
					first = false;
				}
				else
				{
					stringBuilder.Append("&");
				}
				stringBuilder.Append(parameter);
				stringBuilder.Append("=");

				string value = parameters[parameter];
				if (value != null)
				{
					string encodedValue = HttpUtility.UrlEncode(value);
					encodedValue = encodedValue.Replace("+", "%20");
					stringBuilder.Append(encodedValue);
				}
			}
			return stringBuilder.ToString();
		}

		public static void CopyStream(Stream fromStream, Stream toStream)
		{
			byte[] buffer = new byte[4096];
			int bytesRead;
			while ((bytesRead = fromStream.Read(buffer, 0, buffer.Length)) > 0)
				toStream.Write(buffer, 0, bytesRead);
		}
	}
}