﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

using System.Data.OleDb;


using System.IO;
using iTextSharp.text;
using iTextSharp.text.pdf;
using iTextSharp.text.html;
using iTextSharp.text.html.simpleparser;

namespace iTextSharpExample
{
    public partial class _Default : System.Web.UI.Page
    {
        public static string strCnx = "Provider=Microsoft.Jet.OLEDB.4.0; Data Source=g:\\access\\CustomerOrderDetails.mdb;Jet OLEDB:System Database=g:\\access\\system.mdw;" 
;


        #region Properties
        Repeater rptItemList;
        Repeater rptOrderedTotAmount;
        #endregion
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void filetesting()
        {

            OleDbConnection cnx = new OleDbConnection(strCnx);
            DataSet ds = new DataSet();

            string catQuery = @"select * from CustomerOrder";
            OleDbCommand objCmd = new OleDbCommand(catQuery, cnx);
            OleDbDataAdapter objDAcategory = new OleDbDataAdapter(objCmd);
            objDAcategory.Fill(ds, "CustomerOrder");

            string totQuery = @"select OrderID,sum(Amount) As [TotalAmount] from OrderedItem where IsActive = '1' group by OrderID";
            objCmd = new OleDbCommand(totQuery, cnx);
            OleDbDataAdapter objDAtotal = new OleDbDataAdapter(objCmd);
            objDAtotal.Fill(ds, "OrderedItem");

            string itemQuery = @"select * from OrderedItem where IsActive='1'";
            objCmd = new OleDbCommand(itemQuery, cnx);
            OleDbDataAdapter objDAitem = new OleDbDataAdapter(objCmd);
            objDAitem.Fill(ds, "OrderedItem");



            DataRelation dRel = new DataRelation("CustomerOrder_OrderedItem", ds.Tables["CustomerOrder"].Columns["OrderID"], ds.Tables["OrderedItem"].Columns["OrderID"]);
            ds.Relations.Add(dRel);
            cusDptInfo.DataSource = ds;
            cusDptInfo.DataBind();

            HttpContext.Current.Response.Clear(); //clear anything in io buffer
            //HttpContext.Current.Response.ContentType = System.Net.Mime.MediaTypeNames.Application.Pdf;
            HttpContext.Current.Response.AddHeader("Content-Disposition", "attachment;filename=iTextSharpExample.pdf");
            HttpContext.Current.Response.Charset = "";
            HttpContext.Current.Response.ContentType = "application/pdf";
            StringWriter stringwrite = new StringWriter();
            HtmlTextWriter htmlwrite = new HtmlTextWriter(stringwrite);

            cusDptInfo.RenderControl(htmlwrite);
            StringReader sr = new StringReader(stringwrite.ToString());
            Document pdfDoc = new Document(PageSize.A4, 50f, 50f, 40f, 40f);



            PdfWriter writer = PdfWriter.GetInstance(pdfDoc, Response.OutputStream);
            HTMLWorker htmlparser = new HTMLWorker(pdfDoc);
            string pcnt;
            pcnt = (writer.CurrentPageNumber - 1).ToString();
            pcnt = pcnt.Substring(1);

            HeaderFooter header = new HeaderFooter(new Phrase("My Company \n Customer Order Details"), false) { Border = Rectangle.NO_BORDER, Alignment = Element.ALIGN_CENTER };


            HeaderFooter footer = new HeaderFooter(new Phrase(pcnt), true) { Border = Rectangle.NO_BORDER, Alignment = Element.ALIGN_CENTER };
            pdfDoc.Header = header;
            pdfDoc.Footer = footer;
            pdfDoc.Open();
            _events e = new _events();

            e.TimerText = DateTime.Now.ToString("MM/dd/yyyy");

            writer.PageEvent = e;

            htmlparser.Parse(sr);
            pdfDoc.NewPage();
            pdfDoc.Close();


            Response.Write(pdfDoc);


        }

        protected void cusDptInfo_ItemDataBound(object sender, RepeaterItemEventArgs e)
        {
       
            RepeaterItem item = e.Item;
            if ((item.ItemType == ListItemType.Item) ||
                (item.ItemType == ListItemType.AlternatingItem))
            {
                rptItemList = (Repeater)e.Item.FindControl("rptItemList");
                DataRowView drv = (DataRowView)item.DataItem;
                rptItemList.DataSource = drv.CreateChildView("CustomerOrder_OrderedItem");
                rptItemList.DataBind();

                rptOrderedTotAmount = (Repeater)e.Item.FindControl("rptOrderedTotAmount");
                DataRowView drvTot = (DataRowView)item.DataItem;
                rptOrderedTotAmount.DataSource = drvTot.CreateChildView("CustomerOrder_OrderedItem");
                rptOrderedTotAmount.DataBind();

            }
       
        }

        protected void pdfReportFromDatabase_Click(object sender, EventArgs e)
        {
            filetesting();
        }
    }

    public class _events : PdfPageEventHelper
    {
        private string _timerText;

        public string TimerText
        {
            get { return _timerText; }
            set { _timerText = value; }
        }

        public override void OnEndPage(PdfWriter writer, Document document)
        {
            base.OnEndPage(writer, document);
            Rectangle page = document.PageSize;
            ColumnText.ShowTextAligned(writer.DirectContent, Element.ALIGN_RIGHT, new Phrase(TimerText), page.Right, page.Height - document.TopMargin, 0);

        }

    }
}
