﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;

public partial class SamplePage : System.Web.UI.Page
{
    int pageSize = 0;
    int gridTopOffset = 100;
    int gridBottomOffset = 50;
    int rowHeight = 20;
    DataTable dt;
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["WindowHeight"] != null)
        {
            pageSize = Convert.ToInt32((Convert.ToInt32(Session["WindowHeight"]) - gridTopOffset - gridBottomOffset) / 20) - 3;
            lblMessage.Text = "PageSize is:" + pageSize.ToString();
        }
        else
        {
            pageSize = 20;
        }

        if (!IsPostBack)
        {

            GridView1.PageSize = pageSize;
            dt = UIHelper.GetData(300);
            GridView1.DataSource = dt;
            GridView1.DataBind();
        }
    }

    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        GridView1.PageSize = pageSize;
        GridView1.DataSource = UIHelper.GetData(300); ;
        GridView1.DataBind();
    }
}