﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="PagingWithListView.aspx.cs"
    Inherits="VTS.Web.UI.PagingWithListView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Paging With List View</title>
    <link href="Styles/Site.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <center>
        <div>
            <asp:ListView ID="lstProfileView" runat="server" DataSourceID="odsPforile" DataKeyNames="ProfileId"
                ItemPlaceholderID="itmPlaceholder" OnItemDataBound="Profile_ItemDataBound" OnSorting="Profile_Sorting">
                <LayoutTemplate>
                    <table cellpadding="0" cellspacing="0" border="0" width="70%">
                        <tr>
                            <td>
                                <h3 class="title">
                                    Effective Paging With List View Control in ASP.NET</h3>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" style="background-color: #9BAAC1; font-family: Arial; font-weight: bold;
                                text-align: left; padding: 4px 2px">
                                PROFILES
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" style="background-color: #384B69">
                                <table id="tlbProfile" runat="server" cellspacing="0" cellpadding="0" border="0"
                                    width="100%">
                                    <tr>
                                        <th align="left" style="width: 10%" class="column_head">
                                            <asp:LinkButton ID="lnkProfileId" runat="server" Text="ProfileId" Style="color: #FFFFFF"
                                                CommandName="Sort" CommandArgument="ProfileId" />
                                            <asp:Image runat="server" ID="SortImage1" ImageUrl="~/Images/asc.png" Visible="false" Width="15" Height="15" class="sort_image"/>
                                        </th>
                                        <th align="left" style="width: 15%;" class="column_head">
                                            <asp:LinkButton ID="lnkName" runat="server" Text="Name" Style="color: #FFFFFF" CommandName="Sort"
                                                CommandArgument="Name" />
                                            <asp:Image runat="server" ID="SortImage2" ImageUrl="~/Images/asc.png" Visible="false"  Width="15" Height="15" class="sort_image"/>
                                        </th>
                                        <th align="left" style="width: 20%" class="column_head">
                                            <asp:LinkButton ID="lnkAddress" runat="server" Text="Address" Style="color: #FFFFFF"
                                                CommandName="Sort" CommandArgument="Address" />
                                            <asp:Image runat="server" ID="SortImage3" ImageUrl="~/Images/asc.png" Visible="false"  Width="15" Height="15" class="sort_image"/>
                                        </th>
                                        <th align="left" style="width: 15%" class="column_head">
                                            <asp:LinkButton ID="lnkEmail" runat="server" Text="Email" Style="color: #FFFFFF"
                                                CommandName="Sort" CommandArgument="Email" />
                                                <asp:Image runat="server" ID="SortImage4" ImageUrl="~/Images/asc.png" Visible="false"  Width="15" Height="15" class="sort_image"/>
                                        </th>
                                        <th align="left" style="width:12%" class="column_head">
                                            <asp:LinkButton ID="lnkMobile" runat="server" Text="Mobile" Style="color: #FFFFFF"
                                                CommandName="Sort" CommandArgument="Mobile" />
                                                <asp:Image runat="server" ID="SortImage5" ImageUrl="~/Images/asc.png" Visible="false"  Width="15" Height="15" class="sort_image"/>
                                        </th>
                                        <th align="left" style="width: 15%; padding-left: 2px;">
                                            <asp:LinkButton ID="lnkStatus" runat="server" Text="Status" Style="color: #FFFFFF"
                                                CommandName="Sort" CommandArgument="Status" />
                                                <asp:Image runat="server" ID="SortImage6" ImageUrl="~/Images/asc.png" Visible="false"  Width="15" Height="15" class="sort_image"/>
                                        </th>
                                    </tr>
                                    <tr id="itmPlaceholder" runat="server">
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <tr style="height: 10px;">
                            <td colspan="6">
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:DataPager ID="dataPagerNumeric" runat="server" PageSize="5">
                                    <Fields>
                                        <asp:NumericPagerField ButtonCount="5" NumericButtonCssClass="numeric_button" CurrentPageLabelCssClass="current_page"
                                            NextPreviousButtonCssClass="next_button" />
                                    </Fields>
                                </asp:DataPager>
                                <td colspan="4" class="number_of_record">
                                    <asp:DataPager ID="dataPageDisplayNumberOfPages" runat="server" PageSize="5">
                                        <Fields>
                                            <asp:TemplatePagerField>
                                                <PagerTemplate>
                                                    <span style="color: Black;">Records:
                                                        <%# Container.StartRowIndex >= 0 ? (Container.StartRowIndex + 1) : 0 %>
                                                        -
                                                        <%# (Container.StartRowIndex + Container.PageSize) > Container.TotalRowCount ? Container.TotalRowCount : (Container.StartRowIndex + Container.PageSize)%>
                                                        of
                                                        <%# Container.TotalRowCount %>
                                                    </span>
                                                </PagerTemplate>
                                            </asp:TemplatePagerField>
                                        </Fields>
                                    </asp:DataPager>
                                </td>
                            </td>
                        </tr>
                    </table>
                </LayoutTemplate>
                <EmptyDataTemplate>
                    <table class="empty_data" runat="server">
                        <tr>
                            <td>
                                No data found.
                            </td>
                        </tr>
                    </table>
                </EmptyDataTemplate>
                <ItemTemplate>
                    <tr>
                        <td align="left" style="width: 7%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblProfileId" runat="server" Width="65" />
                        </td>
                        <td align="left" style="width: 10%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblName" runat="server" />
                        </td>
                        <td align="left" style="width: 25%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblAddress" runat="server" />
                        </td>
                        <td align="left" style="width: 25%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblEmail" runat="server" />
                        </td>
                        <td align="left" style="width: 15%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblMobile" runat="server" />
                        </td>
                        <td align="left" style="width: 8%;" class='<%# Container.DataItemIndex % 2 == 0 ? "alternate_row" : "row" %>'>
                            <asp:Label ID="lblStatus" runat="server" />
                        </td>
                    </tr>
                </ItemTemplate>
            </asp:ListView>
        </div>
    </center>
    <asp:ObjectDataSource ID="odsPforile" runat="server" SelectMethod="GetProfileData"
        SelectCountMethod="TotalRowCount" EnablePaging="true" MaximumRowsParameterName="pageSize"
        StartRowIndexParameterName="startRowIndex" TypeName="VTS.Web.UI.ProfileDataSource"
        SortParameterName="sortExpression">
        <SelectParameters>
            <asp:Parameter Name="startRowIndex" Type="Int32" />
            <asp:Parameter Name="pageSize" Type="Int32" />
            <asp:Parameter Name="sortExpression" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </form>
</body>
</html>
