﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using SocialMediaLibrary;
using TweetSharp.Model;
using TweetSharp.Twitter.Extensions;
using TweetSharp.Twitter.Fluent;
using TweetSharp.Twitter.Model;


namespace TwitterSample
{
    public partial class _Default : System.Web.UI.Page
    {

        TwitterInfo ti = new TwitterInfo();

        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindData();
            }        
            
        }

        protected void btnTweet_Click(object sender, EventArgs e)
        {   
            //Post the tweet, and automatically shrink urls if requested
            TwitterInfo.TwitterInfoStatus status = ti.PostTweet(tbxTweet.Text, chkMinimizeUrls.Checked);

            //Warn if we're past the max length
            if (status == TwitterInfo.TwitterInfoStatus.ExceededMaxLength)
            {
                ltlInfo.Text = "You have exceeded the twitter max length of 140 characters";
            }
            else
            {
                //Otherwise, get the last tweet and display it
                ltlInfo.Text = "You tweeted successfully!  Your tweet is: " + ti.GetLastTweet().Text;
                BindData();
            }
        }

        protected void BindData()
        {
            //Access the fluent twitter api through the ti.Twitter property.  In this case, load all the user's tweets
            rptTweets.DataSource = ti.Twitter.Statuses().OnUserTimeline().For(ti.UserId).AsJson().Request().AsStatuses().ToList();
            rptTweets.DataBind();
        }
    }
}
