﻿
// Hide each cell in a gridview column
function HideCol(gridView, colIndex, colName) {    
    var rows = document.getElementById(gridView).rows;    
    for(i = 0; i < rows.length; i++)
        if(rows[i].id != gridView + "_pager") 
            rows[i].cells[colIndex].style.display = "none";
    // Add the name and index of the hidden column to the dropdown list
    var hiddenCols = document.getElementById(gridView + "_showCols");   
    hiddenCols.options[hiddenCols.length] = new Option(colName, colIndex);
    
    SetupHiddenCols(gridView);
}

// Show each cell in a gridview column    
function ShowCol(gridView, colIndex) {
    var rows = document.getElementById(gridView).rows;    
    for(i = 0; i < rows.length; i++)
        if(rows[i].id != gridView + "_pager") 
            rows[i].cells[colIndex].style.display = ""; 
    // Remove the name and index of the hidden column from the dropdown list
    var hiddenCols = document.getElementById(gridView + "_showCols");
    for(i = 0; i < hiddenCols.options.length; i++)
        if(hiddenCols.options[i].value == colIndex)
            hiddenCols.options[i] = null;
    
    SetupHiddenCols(gridView);        
}

// Setup the drop down list to show the hidden columns
function SetupHiddenCols(gridView) {
    var hiddenCols = document.getElementById(gridView + "_showCols");
    if(hiddenCols)
        if(hiddenCols.options.length > 1)
            hiddenCols.style.display = "";
        else
            hiddenCols.style.display = "none";
}