﻿#Region "Directives"

Imports System
Imports System.Collections
Imports System.Collections.Generic
Imports System.Configuration
Imports System.Data
Imports System.Web
Imports System.Web.Security
Imports System.Web.UI
Imports System.Web.UI.HtmlControls
Imports System.Web.UI.WebControls
Imports System.Web.UI.WebControls.WebParts
Imports System.Text

#End Region

Partial Public Class ShowHideGridViewColumnsServerVB
    Inherits System.Web.UI.Page

#Region "Properties & Fields"

    ''' <summary> 
    ''' List of column names 
    ''' </summary> 
    Private columnNames As List(Of String) = New List(Of String)(New String() _
        {"Id", "Description", "Assigned To", "Status"})

    Private Property hiddenColumnIndexes() As List(Of Integer)
        Get
            Return If(ViewState("hiddenColumnIndexes") Is Nothing, New List(Of Integer)(), DirectCast(ViewState("hiddenColumnIndexes"), List(Of Integer)))
        End Get
        Set(ByVal value As List(Of Integer))
            ViewState("hiddenColumnIndexes") = value
        End Set
    End Property

#End Region

#Region "Page Load"

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        If Not IsPostBack Then
            _sampleData = Nothing

            ' Populate the GridView 
            Me.GridView1.DataSource = _sampleData
            Me.GridView1.DataBind()

            hiddenColumnIndexes = New List(Of Integer)()
        End If
    End Sub

#End Region

#Region "Control Events"

    Protected Sub GridView1ShowHideColumns_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)
        If Me.GridView1ShowHideColumns.SelectedIndex > 0 Then
            Dim columnIndex As Integer = Integer.Parse(Me.GridView1ShowHideColumns.SelectedValue)
            hiddenColumnIndexes.Remove(columnIndex)

            SetupShowHideColumns()
        End If
    End Sub

#End Region

#Region "GridView Events"

    Protected Sub GridView1_RowCommand(ByVal sender As Object, ByVal e As GridViewCommandEventArgs)
        If e.CommandName = "hideCol" Then
            ' Add the column index to hide to the hiddenColumnIndexes list 
            hiddenColumnIndexes.Add(Integer.Parse(e.CommandArgument.ToString()))
        End If

        SetupShowHideColumns()
    End Sub

    Protected Sub GridView1_RowCreated(ByVal sender As Object, ByVal e As GridViewRowEventArgs)
        ' For the header row add a link button to each header 
        ' cell which can execute a row command 
        If e.Row.RowType = DataControlRowType.Header Then
            ' Loop through each cell of the header row 
            For columnIndex As Integer = 0 To e.Row.Cells.Count - 1
                Dim hideLink As New LinkButton()
                hideLink.CommandName = "hideCol"
                hideLink.CommandArgument = columnIndex.ToString()
                hideLink.Text = "-"
                hideLink.CssClass = "gvHideColLink"
                hideLink.Attributes.Add("title", "Hide Column")

                ' Add the "Hide Column" LinkButton to the header cell 
                e.Row.Cells(columnIndex).Controls.AddAt(0, hideLink)

                ' If there is column header text then 
                ' add it back to the header cell as a label 
                If e.Row.Cells(columnIndex).Text.Length > 0 Then
                    Dim columnTextLabel As New Label()
                    columnTextLabel.Text = e.Row.Cells(columnIndex).Text
                    e.Row.Cells(columnIndex).Controls.Add(columnTextLabel)
                End If
            Next
        End If

        ' Hide the column indexes which have been stored in hiddenColumnIndexes 
        For Each columnIndex As Integer In hiddenColumnIndexes
            If columnIndex < e.Row.Cells.Count Then
                e.Row.Cells(columnIndex).Visible = False
            End If
        Next
    End Sub

#End Region

#Region "Private Methods"

    ''' <summary> 
    ''' Setup the drop down list, adding options based on the hiddenColumnIndexes list 
    ''' </summary> 
    Private Sub SetupShowHideColumns()
        Me.GridView1ShowHideColumns.Items.Clear()

        If hiddenColumnIndexes.Count > 0 Then
            Me.GridView1ShowHideColumns.Visible = True
            Me.GridView1ShowHideColumns.Items.Add(New ListItem("-Show Column-", "-1"))

            For Each i As Integer In hiddenColumnIndexes
                Me.GridView1ShowHideColumns.Items.Add(New ListItem(columnNames(i), i.ToString()))
            Next
        Else
            Me.GridView1ShowHideColumns.Visible = False
        End If

        ' Populate the GridView 
        Me.GridView1.DataSource = _sampleData
        Me.GridView1.DataBind()
    End Sub

#End Region

#Region "Sample Data"

    ''' <summary> 
    ''' Property to manage data 
    ''' </summary> 
    Private Property _sampleData() As DataTable
        Get
            Dim dt As DataTable = DirectCast(Session("TestData"), DataTable)

            If dt Is Nothing Then
                ' Create a DataTable and save it to session 
                dt = New DataTable()

                dt.Columns.Add(New DataColumn("Id", GetType(Integer)))
                dt.Columns.Add(New DataColumn("Description", GetType(String)))
                dt.Columns.Add(New DataColumn("AssignedTo", GetType(String)))
                dt.Columns.Add(New DataColumn("Status", GetType(String)))

                dt.Rows.Add(New Object() {1, "Create a new project", "John", "Complete"})
                dt.Rows.Add(New Object() {2, "Build a demo applcation", "Helen", "In Progress"})
                dt.Rows.Add(New Object() {3, "Test the demo applcation", "Peter", "Pending"})
                dt.Rows.Add(New Object() {4, "Deploy the demo applcation", "Andy", "Pending"})
                dt.Rows.Add(New Object() {5, "Support the demo applcation", "Claire", "Pending"})

                ' Add the id column as a primary key 
                Dim keys As DataColumn() = New DataColumn(0) {}
                keys(0) = dt.Columns("id")
                dt.PrimaryKey = keys

                _sampleData = dt
            End If

            Return dt
        End Get
        Set(ByVal value As DataTable)
            Session("TestData") = value
        End Set
    End Property

#End Region

End Class
