﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Text;

public partial class ShowHideGridViewColumnsServerFull : System.Web.UI.Page
{
    #region Properties & Fields

    /// <summary>
    /// List of column names
    /// </summary>
    List<string> columnNames = new List<string>() { "", "Id", "Description", "Assigned To", "Status" };

    private List<int> hiddenColumnIndexes
    {
        get
        {
            return ViewState["hiddenColumnIndexes"] == null ? new List<int>() : (List<int>)ViewState["hiddenColumnIndexes"];
        }
        set
        {
            ViewState["hiddenColumnIndexes"] = value;
        }
    }

    #endregion

    #region Page Load

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            hiddenColumnIndexes = new List<int>();

            // If columns need to be hidden by default 
            // then add those column indexes to hiddenColumnIndexes
            // list and call SetupShowHideColumns
            hiddenColumnIndexes.Add(1);
            SetupShowHideColumns();
        }
    }

    #endregion

    #region Control Events

    protected void GridView1ShowHideColumns_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (this.GridView1ShowHideColumns.SelectedIndex > 0)
        {
            int columnIndex = int.Parse(this.GridView1ShowHideColumns.SelectedValue);
            hiddenColumnIndexes.Remove(columnIndex);

            GridView1.DataBind();
            SetupShowHideColumns();
        }
    }

    #endregion

    #region GridView Events

    protected void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "hideCol")
        {
            // Add the column index to hide to the hiddenColumnIndexes list
            hiddenColumnIndexes.Add(int.Parse(e.CommandArgument.ToString()));
        }

        GridView1.DataBind();
        SetupShowHideColumns();
    }

    protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
    {
        // For the header row add a link button to each header
        // cell which can execute a row command
        if (e.Row.RowType == DataControlRowType.Header)
        {
            // Loop through each cell of the header row
            for (int columnIndex = 1; columnIndex < e.Row.Cells.Count; columnIndex++)
            {
                LinkButton hideLink = new LinkButton();
                hideLink.CommandName = "hideCol";
                hideLink.CommandArgument = columnIndex.ToString();
                hideLink.Text = "-";
                hideLink.CssClass = "gvHideColLink";
                hideLink.Attributes.Add("title", "Hide Column");

                // Add the "Hide Column" LinkButton to the header cell
                e.Row.Cells[columnIndex].Controls.AddAt(0, hideLink);

                // If there is column header text then
                // add it back to the header cell as a label
                if (e.Row.Cells[columnIndex].Text.Length > 0)
                {
                    Label columnTextLabel = new Label();
                    columnTextLabel.Text = e.Row.Cells[columnIndex].Text;
                    e.Row.Cells[columnIndex].Controls.Add(columnTextLabel);
                }                
            }
        }

        // Add a CSS class to hide the edit buttons when printing
        if (e.Row.RowType == DataControlRowType.Header
            || e.Row.RowType == DataControlRowType.DataRow)
            e.Row.Cells[0].CssClass = "printHideMe";

        // Add a CSS class to hide the pager when printing
        if (e.Row.RowType == DataControlRowType.Pager)
            e.Row.CssClass = "printHideMe";

        // Hide the column indexes which have been stored in hiddenColumnIndexes
        foreach (int columnIndex in hiddenColumnIndexes)
            if (columnIndex < e.Row.Cells.Count)
                e.Row.Cells[columnIndex].Visible = false;
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Setup the drop down list, adding options based on the hiddenColumnIndexes list 
    /// </summary>
    private void SetupShowHideColumns()
    {
        this.GridView1ShowHideColumns.Items.Clear();

        if (hiddenColumnIndexes.Count > 0)
        {
            this.GridView1ShowHideColumns.Visible = true;
            this.GridView1ShowHideColumns.Items.Add(new ListItem("-Show Column-", "-1"));

            foreach (int i in hiddenColumnIndexes)
                this.GridView1ShowHideColumns.Items.Add(new ListItem(columnNames[i], i.ToString()));
        }
        else
        {
            this.GridView1ShowHideColumns.Visible = false;
        }
    }
    #endregion
}
