﻿<%@ Page Title="Show / Hide Gridview Columns on the Server Side" Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="ShowHideGridViewColumnsServerFull.aspx.cs" Inherits="ShowHideGridViewColumnsServerFull" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">

</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="BodyContent" Runat="Server">
    <h3>Show / Hide Gridview Columns on the Server Side</h3>
    <a class="printHideMe" href="Default.aspx">Back to Menu</a>
    <p class="description">
        Try clicking on the minus symbols in the GridView column headers.
        <br />Use the dropdown list to show the columns again.
        <br />Try "Print Preview" in your browser to see how the page will print.
        <br /><br />This example uses a SqlDataSource control and includes a MasterPage,
        <br />an UpdatePanel and GridView editing, paging and sorting.
        <br />Also, the Id column is hidden by default.
    </p>
    <asp:UpdatePanel ID="UpdatePanel1" runat="server">
        <ContentTemplate> 
            <asp:GridView ID="GridView1" runat="server"
                OnRowCreated="GridView1_RowCreated"
                OnRowCommand="GridView1_RowCommand" 
                DataSourceID="SqlDataSource1" DataKeyNames="Id"
                AllowSorting="True" AllowPaging="True" PageSize="3"
                AutoGenerateColumns="False">
                <HeaderStyle CssClass="gvHeader" />
                <RowStyle CssClass="gvRow" />
                <Columns>
                    <asp:CommandField ShowEditButton="True" />
                    <asp:TemplateField HeaderText="Id" SortExpression="Id">
                        <ItemTemplate>
                            <asp:Label ID="IdLabel" runat="server" Text='<%# Eval("Id") %>'></asp:Label>
                        </ItemTemplate>   
                        <EditItemTemplate>
                            <asp:Label ID="Id" runat="server" Text='<%# Bind("Id") %>'></asp:Label>
                        </EditItemTemplate>            
                    </asp:TemplateField>                    
                    <asp:TemplateField HeaderText="Description" SortExpression="Description">
                        <ItemTemplate>
                            <asp:Label ID="DescriptionLabel" runat="server" Text='<%# Eval("Description") %>'></asp:Label>
                        </ItemTemplate>   
                        <EditItemTemplate>
                            <asp:TextBox ID="Description" runat="server" Text='<%# Bind("Description") %>' Width="175px"></asp:TextBox>
                        </EditItemTemplate>            
                    </asp:TemplateField>                    
                    <asp:TemplateField HeaderText="Assigned To" SortExpression="AssignedTo">
                        <ItemTemplate>
                            <asp:Label ID="AssignedToLabel" runat="server" Text='<%# Eval("AssignedTo") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="AssignedTo" runat="server" SelectedValue='<%# Bind("AssignedTo") %>'>
                                <asp:ListItem></asp:ListItem>
                                <asp:ListItem>Andy</asp:ListItem>
                                <asp:ListItem>Betty</asp:ListItem>
                                <asp:ListItem>Conor</asp:ListItem>
                                <asp:ListItem>Declan</asp:ListItem>
                                <asp:ListItem>Eamon</asp:ListItem>
                                <asp:ListItem>Fergal</asp:ListItem>
                                <asp:ListItem>Gordon</asp:ListItem>
                                <asp:ListItem>Helen</asp:ListItem>
                                <asp:ListItem>Iris</asp:ListItem>
                                <asp:ListItem>John</asp:ListItem>
                                <asp:ListItem>Kevin</asp:ListItem>
                                <asp:ListItem>Lorna</asp:ListItem>
                                <asp:ListItem>Matt</asp:ListItem>
                                <asp:ListItem>Nora</asp:ListItem>
                                <asp:ListItem>Olive</asp:ListItem>
                                <asp:ListItem>Peter</asp:ListItem>
                                <asp:ListItem>Claire</asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Status" SortExpression="Status">
                        <ItemTemplate>
                            <asp:Label ID="StatusLabel" runat="server" Text='<%# Eval("Status") %>'></asp:Label>
                        </ItemTemplate>
                        <EditItemTemplate>
                            <asp:DropDownList ID="Status" runat="server" SelectedValue='<%# Bind("Status") %>'>
                                <asp:ListItem>Pending</asp:ListItem>
                                <asp:ListItem>In Progress</asp:ListItem>
                                <asp:ListItem>Complete</asp:ListItem>
                                <asp:ListItem>Cancelled</asp:ListItem>
                                <asp:ListItem>Suspended</asp:ListItem>
                            </asp:DropDownList>
                        </EditItemTemplate>
                    </asp:TemplateField>
                </Columns>                 
            </asp:GridView>
            <div class="showHideColumnsContainer">
                <asp:DropDownList ID="GridView1ShowHideColumns" runat="server" Visible="false" 
                    AutoPostBack="true" OnSelectedIndexChanged="GridView1ShowHideColumns_SelectedIndexChanged" />
            </div>        
        </ContentTemplate>
    </asp:UpdatePanel>    
    <asp:SqlDataSource ID="SqlDataSource1" runat="server" ConnectionString="<%$ ConnectionStrings:ConnectionString %>"
        SelectCommand="SELECT * FROM [Tasks]" 
        InsertCommand="INSERT INTO [Tasks] ([Description], [AssignedTo], [Status]) VALUES (@Description, @AssignedTo, @Status)"
        UpdateCommand="UPDATE [Tasks] SET [Description] = @Description, [AssignedTo] = @AssignedTo, [Status] = @Status WHERE [Id] = @Id"
        DeleteCommand="DELETE FROM [Tasks] WHERE [Id] = @Id" >
        <DeleteParameters>
            <asp:Parameter Name="Id" Type="Int32" />
        </DeleteParameters>
        <UpdateParameters>
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="AssignedTo" Type="String" />
            <asp:Parameter Name="Status" Type="String" />
            <asp:Parameter Name="Id" Type="Int32" />
        </UpdateParameters>
        <InsertParameters>
            <asp:Parameter Name="Description" Type="String" />
            <asp:Parameter Name="AssignedTo" Type="String" />
            <asp:Parameter Name="Status" Type="String" />
        </InsertParameters>
    </asp:SqlDataSource>    
</asp:Content>

