﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Text;

public partial class ShowHideGridViewColumnsClient : System.Web.UI.Page
{
    #region Properties & Fields

    /// <summary>
    /// List of column names
    /// </summary>
    List<string> columnNames = new List<string>() { "Id", "Description", "Assigned To", "Status" };

    #endregion

    #region Page Load

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            _sampleData = null;

            // Populate the GridView
            this.GridView1.DataSource = _sampleData;
            this.GridView1.DataBind();

            // Setup the dropdown list to allow the user to show hidden columns
            SetupShowHideColumns(this.GridView1, this.GridView1ShowHideColumns);
        }
    }

    #endregion

    #region GridView Events

    protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
    {
        GridView gridView = (GridView)sender;
        StringBuilder sb = new StringBuilder();

        // For the header row add a link to each header
        // cell which can call the HideCol javascript method
        if (e.Row.RowType == DataControlRowType.Header)
        {
            // Loop through each cell of the row
            for (int columnIndex = 0; columnIndex < e.Row.Cells.Count; columnIndex++)
            {
                // Build the hide column link
                sb.Remove(0, sb.Length); // first empty the StringBuilder
                sb.Append("javascript:HideCol('");
                sb.Append(gridView.ClientID);
                sb.Append("', ");
                sb.Append(columnIndex);
                sb.Append(", '");
                sb.Append(columnNames[columnIndex]);
                sb.Append("');");

                // Build the "Hide Column" HyperLink control
                HyperLink hideLink = new HyperLink();
                hideLink.Text = "-";
                hideLink.CssClass = "gvHideColLink";
                hideLink.NavigateUrl = sb.ToString();
                hideLink.Attributes.Add("title", "Hide Column");

                // Add the "Hide Column" HyperLink to the header cell
                e.Row.Cells[columnIndex].Controls.AddAt(0, hideLink);

                // If there is column header text then
                // add it back to the header cell as a label
                if (e.Row.Cells[columnIndex].Text.Length > 0)
                {
                    Label columnTextLabel = new Label();
                    columnTextLabel.Text = e.Row.Cells[columnIndex].Text;
                    e.Row.Cells[columnIndex].Controls.Add(columnTextLabel);
                }
            }
        }

        // Give each row an id
        if (e.Row.RowType == DataControlRowType.Pager)
            e.Row.Attributes.Add("id", gridView.ClientID + "_pager");
        else
            e.Row.Attributes.Add("id", gridView.ClientID + "_r" + e.Row.RowIndex.ToString());
    }

    #endregion

    #region Private Methods

    /// <summary>
    /// Method to build up the html for the dropdown list which 
    /// will contain the names of the hidden columns.
    /// </summary>
    /// <param name="gridView">GridView control</param>
    /// <param name="showHideColumnsLiteral">Literal control to display client side show/hide columns dropdown</param>
    private void SetupShowHideColumns(GridView gridView, Literal showHideColumnsLiteral)
    {
        StringBuilder sb = new StringBuilder();

        sb.Append("<div class=\"showHideColumnsContainer\">");
        sb.Append("<select id=\"");
        sb.Append(gridView.ClientID);
        sb.Append("_showCols\" onchange=\"javascript:ShowCol('");
        sb.Append(gridView.ClientID);
        sb.Append("', this.value);\" style=\"display:none;\">");
        sb.Append("<option>- Show Column -</option></select></div>");

        showHideColumnsLiteral.Text = sb.ToString();
    }

    #endregion

    #region Sample Data

    /// <summary>
    /// Property to manage data
    /// </summary>
    private DataTable _sampleData
    {
        get
        {
            DataTable dt = (DataTable)Session["TestData"];

            if (dt == null)
            {
                // Create a DataTable and save it to session
                dt = new DataTable();

                dt.Columns.Add(new DataColumn("Id", typeof(int)));
                dt.Columns.Add(new DataColumn("Description", typeof(string)));
                dt.Columns.Add(new DataColumn("AssignedTo", typeof(string)));
                dt.Columns.Add(new DataColumn("Status", typeof(string)));

                dt.Rows.Add(new object[] { 1, "Create a new project", "John", "Complete" });
                dt.Rows.Add(new object[] { 2, "Build a demo applcation", "Helen", "In Progress" });
                dt.Rows.Add(new object[] { 3, "Test the demo applcation", "Peter", "Pending" });
                dt.Rows.Add(new object[] { 4, "Deploy the demo applcation", "Andy", "Pending" });
                dt.Rows.Add(new object[] { 5, "Support the demo applcation", "Claire", "Pending" });

                // Add the id column as a primary key
                DataColumn[] keys = new DataColumn[1];
                keys[0] = dt.Columns["id"];
                dt.PrimaryKey = keys;

                _sampleData = dt;
            }

            return dt;
        }
        set
        {
            Session["TestData"] = value;
        }
    }

    #endregion
}
