﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using Newtonsoft.Json.Linq;   //downloaded JSON.net from http://james.networking.com/projects/json-net.aspx


namespace CodeProjects
{
    public partial class DataProcessor : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
                ProcessAjaxRequest();



        }




        private void ProcessAjaxRequest()
        {
            if (Request.ContentType.Contains("json") && Request.QueryString["Save"] != null)
                SaveMyData();




        }


        private void SaveMyData()
        {
           
            //data passed in as JSON format
            System.IO.StreamReader sr = new System.IO.StreamReader(Request.InputStream);
            string line = "";
            //while (!sr.EndOfStream)
            //{

            //    line = sr.ReadLine();        //do not do Server.UrlDecode here as it might render those escaped characters that will blow up JObject parsing
            //    Console.WriteLine(line);


            //}

            line = sr.ReadToEnd();

            
            //This is all you need to parse JSON string into an JObject. 
            //Require namespace Newtonsoft.Json.Linq;
            JObject jo = JObject.Parse(line);
            
            Console.WriteLine((string)jo["RecordID"]);
            Console.WriteLine(Server.UrlDecode((string)jo["ItemName"])); //use Server.UrlDecode to reverse the text that was escaped before it was passed in to its original state

            //do data saving logic here and return the recordid
            //int recordid=SaveToDataBase(jo);
            //Response.Write(recordid.ToString());

            Response.Write((string)jo["CategoryID"]); //this send to responseText of .ajax(options).responseText




        }


    }
}
