Imports System
Imports System.IO
Imports iTextSharp.text
Imports iTextSharp.text.pdf

Partial Class ShowPDF
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Request.QueryString("id") = 1 Then
            ShowHello()
        Else
            ShowTable()
        End If
    End Sub

    Sub ShowHello()
        Dim doc As Document = New Document
        PdfWriter.GetInstance(doc, New FileStream(Request.PhysicalApplicationPath + "\1.pdf", FileMode.Create))
        doc.Open()
        doc.Add(New Paragraph("Hello World"))
        doc.Close()
        Response.Redirect("~/1.pdf")
    End Sub

    Sub ShowTable()
        Dim doc As Document = New Document
        PdfWriter.GetInstance(doc, New FileStream(Request.PhysicalApplicationPath + "\2.pdf", FileMode.Create))
        doc.Open()
        Dim table As Table = New Table(3)
        table.BorderWidth = 1
        table.BorderColor = New Color(0, 0, 255)
        table.Padding = 3
        table.Spacing = 1
        Dim cell As Cell = New Cell("header")
        cell.Header = True
        cell.Colspan = 3
        table.AddCell(cell)
        cell = New Cell("example cell with colspan 1 and rowspan 2")
        cell.Rowspan = 2
        cell.BorderColor = New Color(255, 0, 0)
        table.AddCell(cell)
        table.AddCell("1.1")
        table.AddCell("2.1")
        table.AddCell("1.2")
        table.AddCell("2.2")
        table.AddCell("cell test1")
        cell = New Cell("big cell")
        cell.Rowspan = 2
        cell.Colspan = 2
        cell.HorizontalAlignment = Element.ALIGN_CENTER
        cell.VerticalAlignment = Element.ALIGN_MIDDLE
        cell.BackgroundColor = New Color(192, 192, 192)
        table.AddCell(cell)
        table.AddCell("cell test2")
        doc.Add(table)
        doc.Close()
        Response.Redirect("~/2.pdf")
    End Sub

End Class
