// This software is provided "AS IS" with no warranties of any kind.
// The entire risk arising out of the use or performance of the software
// and source code is with you.

using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Web.Management;

namespace HealthMonitoring
{
	/// <summary>
	/// An example web event that implements the ILoggerEvent interface
	/// </summary>
	/// <remarks>
	/// This web event allows the additional information that log4net needs to be passed
	/// to customize the logging behavior of the event
	/// </remarks>
	public class LoggerWebRequestEvent : WebRequestEvent, ILoggerEvent
	{
		private Level _level = Level.Default;
		private string _logName;

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="message">The message.</param>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		public LoggerWebRequestEvent(string message, object eventSource, int eventCode)
			: base(message, eventSource, eventCode)
		{
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="message">The message associated with the event.</param>
		/// <param name="eventSource">The object that is the source of the event.</param>
		/// <param name="eventCode">The <see cref="T:System.Web.Management.WebEventCodes"></see> code associated with the event. It must be greater than <see cref="F:System.Web.Management.WebEventCodes.WebExtendedBase"></see>.</param>
		/// <param name="eventDetailCode">The <see cref="T:System.Web.Management.WebEventCodes"></see> detail code associated with the event.</param>
		public LoggerWebRequestEvent(string message, object eventSource, int eventCode, int eventDetailCode)
			: base(message, eventSource, eventCode, eventDetailCode)
		{
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="message">The message.</param>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		/// <param name="level">The level.</param>
		public LoggerWebRequestEvent(string message, object eventSource, int eventCode, Level level)
			: this(message, eventSource, eventCode)
		{
			_level = level;
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="message">The message.</param>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		/// <param name="level">The level.</param>
		/// <param name="logName">Name of the log.</param>
		public LoggerWebRequestEvent(string message, object eventSource, int eventCode, Level level, string logName)
			: this(message, eventSource, eventCode, level)
		{
			if (!string.IsNullOrEmpty(logName))
			{
				_logName = logName;
			}
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		/// <param name="messageFormat">The message format.</param>
		/// <param name="args">The args.</param>
		public LoggerWebRequestEvent(object eventSource, int eventCode, string messageFormat, params object[] args)
			: this(string.Format(messageFormat, args), eventSource, eventCode)
		{
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		/// <param name="level">The level.</param>
		/// <param name="messageFormat">The message format.</param>
		/// <param name="args">The args.</param>
		public LoggerWebRequestEvent(object eventSource, int eventCode, Level level, string messageFormat, params object[] args)
			: this(string.Format(messageFormat, args), eventSource, eventCode, level)
		{
		}

		/// <summary>
		/// Initializes a new instance of the <see cref="LoggerWebRequestEvent"/> class.
		/// </summary>
		/// <param name="eventSource">The event source.</param>
		/// <param name="eventCode">The event code.</param>
		/// <param name="level">The level.</param>
		/// <param name="logName">Name of the log.</param>
		/// <param name="messageFormat">The message format.</param>
		/// <param name="args">The args.</param>
		public LoggerWebRequestEvent(object eventSource, int eventCode, Level level, string logName, string messageFormat, params object[] args)
			: this(string.Format(messageFormat, args), eventSource, eventCode, level, logName)
		{
		}

		/// <summary>
		/// The level this event should be logged at
		/// </summary>
		/// <value></value>
		public Level Level
		{
			get
			{
				return _level;
			}
			set
			{
				_level = value;
			}
		}

		/// <summary>
		/// The name of the log to log this event to
		/// </summary>
		/// <value></value>
		public string LogName
		{
			get
			{
				return _logName;
			}
			set
			{
				_logName = value;
			}
		}
	}
}
