// This software is provided "AS IS" with no warranties of any kind.
// The entire risk arising out of the use or performance of the software
// and source code is with you.

using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using log4net;
using log4net.Config;

namespace HealthMonitoring
{
	public class Global : System.Web.HttpApplication
	{
		/// <summary>
		/// Handles the Start event of the Application control.
		/// </summary>
		/// <param name="sender">The source of the event.</param>
		/// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
		protected void Application_Start(object sender, EventArgs e)
		{
			// Configure log4net
			XmlConfigurator.Configure();
		}

		/// <summary>
		/// Handles the End event of the Application control.
		/// </summary>
		/// <param name="sender">The source of the event.</param>
		/// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
		protected void Application_End(object sender, EventArgs e)
		{

		}

		/// <summary>
		/// Handles the PreRequestHandlerExecute event of the Application control.
		/// </summary>
		/// <param name="sender">The source of the event.</param>
		/// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
		protected void Application_PreRequestHandlerExecute(object sender, EventArgs e)
		{
			// Add the properties so the session can be traced with the logging statements
			string userName = "none";
			try
			{
				if (User.Identity.IsAuthenticated)
				{
					userName = User.Identity.Name;
				}

			}
			catch (Exception)
			{
				// Do nothing the user could not be fetched
			}
			ThreadContext.Properties["UserName"] = userName;


			string sessionId = "none";
			try
			{
				if (Session != null)
				{
					sessionId = Session.SessionID;
				}
			}
			catch (Exception)
			{
				// Do nothing session just did not exist (for instance the webresource.axd)
			}

			ThreadContext.Properties["SessionId"] = sessionId;
		}

	}
}