﻿<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" />
  <xsl:param name="top" />
  <xsl:param name="page" />
  <xsl:param name="searchterm" />

  <xsl:template match="/">
    You searched for "<xsl:value-of select="$searchterm" />"<br />
    <hr />
    <xsl:for-each select="rss/channel/item">
      <xsl:if test="position() &lt; ($top*($page+1)) + 1 and position() &gt; $page * $top">
        <a href = "{link}">
          <span class="style1">
            <strong>
              <xsl:value-of select="title" />
            </strong>
          </span>
        </a>
        <br />
        <span class="style1">
          <xsl:value-of disable-output-escaping="no" select="translate(substring(description,1,150),'/',' /')" />
          <xsl:value-of disable-output-escaping="no" select="' ...'" />
        </span>
        <br />
        <xsl:value-of select="link" />
        <br />
        <br />
      </xsl:if>
      <xsl:if test = "position()=last()">
        <hr />
        <div>
          <div class="paginate">
            <xsl:if test = "($page = 0) and ($top&lt;last()-1)">
              <a href = "javascript:javascript:__doPostBack('LbHoldClick','{$page+1}');">next &gt;&gt;</a>
            </xsl:if>
            <xsl:if test = "not($page = 0)">
              <xsl:if test = "$top*($page+1) &gt; last()-1">
                <a href = "javascript:javascript:__doPostBack('LbHoldClick','{($page)-1}');">&lt;&lt; prev</a>
              </xsl:if>
              <xsl:if test = "not($top*($page+1) &gt; last()-1)">
                <a href = "javascript:javascript:__doPostBack('LbHoldClick','{($page)-1}');">&lt;&lt; prev</a>
                <xsl:text disable-output-escaping="yes">&amp;nbsp;|&amp;nbsp;</xsl:text>
                <a href = "javascript:javascript:__doPostBack('LbHoldClick','{$page+1}');">next &gt;&gt;</a>
              </xsl:if>
            </xsl:if>
          </div>
          You searched for "<xsl:value-of select="$searchterm" />"<br />
          We found <strong>
            <xsl:value-of select="last()" />
          </strong> results. Displaying <strong>
            <xsl:value-of select="($page * $top) + 1" /> to <xsl:value-of select="$top*($page+1)" />
          </strong><br />
        </div>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>