﻿Imports System.Xml
Imports System.Xml.Xsl
Imports System.IO

Partial Public Class _Default
    Inherits System.Web.UI.Page

#Region "Constants"
    ''' <summary>
    ''' sitename
    ''' </summary>
    ''' <remarks></remarks>
    Const sitename As String = "aprogrammersjournal.com"

    ''' <summary>
    ''' resultcount
    ''' </summary>
    ''' <remarks></remarks>
    Const resultcount As Int32 = 100

    ''' <summary>
    ''' start
    ''' </summary>
    ''' <remarks></remarks>
    Const start As Int32 = 1

    ''' <summary>
    ''' MSNSearchURL
    ''' </summary>
    ''' <remarks></remarks>
    Const MSNSearchURL As String = "http://search.msn.com/results.aspx?q=site%3a"

    ''' <summary>
    ''' XslTranformFile
    ''' </summary>
    ''' <remarks></remarks>
    Const XslTranformFile As String = "msn-XSL.xsl"

#End Region

#Region "Protected Declorations"
    Protected searchterm As String
    Protected top As String
    Protected pagenum As String
    Protected pagenumdbl As Double
    Protected failcount As Integer = 0
#End Region

    ''' <summary>
    ''' Page_Load
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        'set properties for search
        SetSearchProperties()

        'display search results.
        DisplaySearchResults()

    End Sub

    ''' <summary>
    ''' DisplaySearchResults
    ''' </summary>
    ''' <remarks></remarks>
    Sub DisplaySearchResults()

        'check if user entered a search term.
        If term.Text <> "" Then

            Try

                'init
                Dim msnXmlSrc As String = MSNSearchURL & sitename & "+" & searchterm & "&format=rss&FORM=ZZRE&count=" & resultcount & "&first=" & start
                Dim msnXslFile As String = Server.MapPath(XslTranformFile)

                'load output into xml document.
                Dim msnXmlDoc As XmlDocument = New XmlDocument()
                msnXmlDoc.Load(msnXmlSrc)

                'set parameters.
                Dim arglist As XsltArgumentList = New XsltArgumentList()
                arglist.AddParam("top", "", top)
                arglist.AddParam("page", "", pagenum)
                arglist.AddParam("searchterm", "", searchterm)

                'Tranform xml/xsl
                Dim out As HtmlGenericControl = _
                    TransformXml(msnXmlDoc, msnXslFile, arglist)

                'add control to placeholder
                If ResultPLC.Controls.Count > 0 Then ResultPLC.Controls.RemoveAt(0)
                ResultPLC.Controls.Add(out)

            Catch ex As Exception
                Try
                    'retry once
                    If failcount > 0 Then Throw New Exception(ex.Message)
                    failcount = failcount + 1
                    DisplaySearchResults()
                Catch ex2 As Exception
                    'message error
                    Dim litOut As New Literal
                    litOut.Text = ex2.Message()
                    ResultPLC.Controls.Add(litOut)
                End Try

            End Try

        Else
            Dim litOut As New Literal
            litOut.Text = "Please enter a search term."
            ResultPLC.Controls.Add(litOut)
        End If

    End Sub

    ''' <summary>
    ''' btnSubmit_OnClick
    ''' </summary>
    ''' <param name="Obj"></param>
    ''' <param name="E"></param>
    ''' <remarks></remarks>
    Protected Sub btnSubmit_OnClick(ByVal Obj As Object, ByVal E As EventArgs)
        'set properties for search
        SetSearchProperties()

        'display search results.
        DisplaySearchResults()
    End Sub

    ''' <summary>
    ''' SetSearchProperties
    ''' </summary>
    ''' <remarks></remarks>
    Protected Sub SetSearchProperties()
        'set search text.
        searchterm = term.Text

        'set number of results per page.
        top = ResultsCount.SelectedValue

        'reset page number on new click.
        pagenum = "0"
    End Sub

    ''' <summary>
    ''' LbHoldClick_Click
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub LbHoldClick_Click(ByVal sender As Object, ByVal e As EventArgs) Handles LbHoldClick.Click

        'set search text.
        searchterm = term.Text

        'get page number
        pagenum = Request.Form("__EVENTARGUMENT")

        'set number of results per page.
        top = ResultsCount.SelectedValue

        'display search results.
        DisplaySearchResults()

    End Sub


    ''' <summary>
    ''' complete a xml/xsl transformation with parameters.
    ''' </summary>
    ''' <param name="xmldoc"></param>
    ''' <param name="stylesheet"></param>
    ''' <returns>HtmlGenericControl</returns>
    ''' <remarks>perform XML/XSL transformation</remarks>
    Public Function TransformXml(ByVal xmldoc As XmlDocument, ByVal stylesheet As String, ByVal params As XsltArgumentList) As System.Web.UI.HtmlControls.HtmlGenericControl
        'init
        Dim m_TransformXml As New System.Web.UI.HtmlControls.HtmlGenericControl
        Dim sw As StringWriter = New StringWriter()
        Dim xslDoc As New XslCompiledTransform()

        Try
            'perform transformation
            xslDoc.Load(stylesheet)
            xslDoc.Transform(xmldoc, params, sw)

        Catch ex As Exception
            'bubble exception
            Throw New Exception(ex.Message())
        Finally
            'free memory
            sw.Dispose()
            xslDoc = Nothing
        End Try

        'return control
        m_TransformXml.InnerHtml = sw.ToString()
        sw.Dispose()
        Return m_TransformXml

    End Function

End Class