using System;
using System.Configuration;

namespace Foulds.Security.SectionHandlers.DataProtection
{
	/// <author>Hannes Foulds, 18 August 2005</author>
	/// <summary>
	/// This class is used to access the encrypted config settings in a .config file.
	/// </summary>
	public class ConfigSettings
	{
		#region Declarations
		private static EncryptedSettings _encrypted;	// the encrypted settings read from the .config file
		#endregion

		#region Properties
		/// <summary>
		/// The encrypted settings read from the .config file.
		/// </summary>
		public static EncryptedSettings Encrypted
		{
			get
			{
				if (_encrypted == null)
					ReadEncryptedSettings();

				return _encrypted;
			}
		}
		#endregion

		#region Constructor
		/// <summary>
		/// Private constructore to ensure that a instance of the class cannot be instanciated.
		/// </summary>
		private ConfigSettings()
		{
		}
		#endregion

		#region Read Encrypted Settings
		/// <summary>
		/// Read the encrypted settings form the .config file.
		/// </summary>
		private static void ReadEncryptedSettings()
		{
			_encrypted = (EncryptedSettings)ConfigurationSettings.GetConfig("fouldsSettings/encrypted");
		}
		#endregion
	}
}
