using System;
using System.IO;
using System.Security.Cryptography;

namespace Foulds.Security.Encryption
{
	/// <author>Hannes Foulds, 11 August 2005</author>
	/// <summary>
	/// This class is used to encrypt data using the Triple DES algorithm.
	/// </summary>
	public class TripleDes : EncryptionBase
	{
		#region Constants
        private byte[] IV = {30, 12, 26, 23, 44, 51, 46, 73}; 
		#endregion

		/// <summary>
		/// Encrypt the plaintext using the key provided.
		/// </summary>
		/// <param name="plainText">The plain text that must be encrypted.</param>
		/// <param name="key">The key to use for the encryption.</param>
		/// <returns>Returns the encrypted byte array.</returns>
		public override byte[] Encrypt(byte[] plainText, byte[] key)
		{
			// create the crypto service provider
			TripleDESCryptoServiceProvider des3 = new TripleDESCryptoServiceProvider();
			des3.Mode = CipherMode.CBC;
			
			// create the key
			PasswordDeriveBytes passwordDeriveBytes = new PasswordDeriveBytes(Convert.ToBase64String(key), new byte[0]);
			des3.Key = passwordDeriveBytes.CryptDeriveKey("RC2", "MD5", 128, new byte[8]);
			des3.IV = this.IV;

			MemoryStream memoryStream = new MemoryStream(); 
			CryptoStream cryptoStream = new CryptoStream(memoryStream, des3.CreateEncryptor(), CryptoStreamMode.Write); 
			cryptoStream.Write(plainText, 0, plainText.Length); 
			cryptoStream.FlushFinalBlock(); 

			return memoryStream.ToArray();
		}

		/// <summary>
		/// Decrypt the ciphertext.
		/// </summary>
		/// <param name="cipherText">The ciphertext that sould be decrypted.</param>
		/// <param name="key">The key to use for the decryption.</param>
		/// <returns>Returns the decrypted bytes.</returns>
		public override byte[] Decrypt(byte[] cipherText, byte[] key)
		{
			// create the crypto service provider
			TripleDESCryptoServiceProvider des3 = new TripleDESCryptoServiceProvider();
			des3.Mode = CipherMode.CBC;

			// create the key
			PasswordDeriveBytes passwordDeriveBytes = new PasswordDeriveBytes(Convert.ToBase64String(key), new byte[0]);
			des3.Key = passwordDeriveBytes.CryptDeriveKey("RC2", "MD5", 128, new byte[8]);
			des3.IV = this.IV;

			MemoryStream memoryStream = new MemoryStream(); 
			CryptoStream cryptoStream = new CryptoStream(memoryStream, des3.CreateDecryptor(), CryptoStreamMode.Write); 
			cryptoStream.Write(cipherText, 0, cipherText.Length); 
			cryptoStream.FlushFinalBlock(); 

			return memoryStream.ToArray();
		}
	}
}
