using System;
using System.Text;

namespace Foulds.Security.Encryption
{
	/// <author>Hannes Foulds, 11 August 2005.</author>
	/// <summary>
	/// All encryption classes should inherit from this base class.
	/// </summary>
	public abstract class EncryptionBase
	{
		#region Encrypt
		/// <summary>
		/// Encrypt the plaintext using the key provided.
		/// </summary>
		/// <param name="plainText">The plain text that must be encrypted.</param>
		/// <param name="key">The key to use for the encryption.</param>
		/// <returns>The base64 encoded cipher text.</returns>
		public string Encrypt(string plainText, string key)
		{
			// get the byte arrays of the input parameters
			byte[] plainBytes = Encoding.ASCII.GetBytes(plainText);
			byte[] keyBytes = ( (key != null) ? Encoding.ASCII.GetBytes(key) : null );

			// encrypt the plain text
			byte[] encryptedBytes = this.Encrypt(plainBytes, keyBytes);

			// return the base64 encrypted string
			return Convert.ToBase64String(encryptedBytes);
		}

		public abstract byte[] Encrypt(byte[] plainText, byte[] key);
		#endregion

		#region Decrypt
		/// <summary>
		/// Decrypt the ciphertext.
		/// </summary>
		/// <param name="cipherText">The ciphertext that sould be decrypted.</param>
		/// <param name="key">The key to use for the decryption.</param>
		/// <returns>Returns the decrypted string.</returns>
		public string Decrypt(string cipherText, string key)
		{
			// get the byte arrays of the input parameters
			byte[] cipherBytes = Convert.FromBase64String(cipherText);
			byte[] keyBytes = ( (key != null) ? Encoding.ASCII.GetBytes(key) : null );

			// decrypt the cipher text
			byte[] decryptedBytes = this.Decrypt(cipherBytes, keyBytes);

			// return the decrypted string
			return Encoding.ASCII.GetString(decryptedBytes);
		}

		public abstract byte[] Decrypt(byte[] cipherText, byte[] key);
		#endregion
	}
}
