using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using Foulds.Security.SectionHandlers.DataProtection;

namespace Foulds.Security.UserInterface.DataProtection
{
	/// <author>Hannes Foulds, 18 August 2005</author>
	/// <summary>
	/// This is the code behind file for the user interface that is used to place the master key in the registry
	/// and encrypt data that should be placed in the config file.
	/// </summary>
	public class EncryptionForm : System.Windows.Forms.Form
	{
		#region User Interface Elements
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.TextBox txtRegistryKey;
		private System.Windows.Forms.TextBox txtMasterKey;
		private System.Windows.Forms.Button btnSave;
		private System.Windows.Forms.Button btnLoad;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.TextBox txtPlainText;
		private System.Windows.Forms.TextBox txtCipherText;
		private System.Windows.Forms.Button btnEncrypt;
		#endregion

		#region Declarations
		/// <summary>Required designer variable.</summary>
		private System.ComponentModel.Container components = null;
		
		/// <summary>The class that will be used to encrypt and decrypt data.</summary>
		protected EncryptionEngine encryptionEngine;
		#endregion

		#region Constructor
		/// <summary>
		/// Initialize a default instance of the class.
		/// </summary>
		public EncryptionForm()
		{
			InitializeComponent();
			this.encryptionEngine = new EncryptionEngine();
		}
		#endregion

		#region Dispose
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.txtRegistryKey = new System.Windows.Forms.TextBox();
			this.txtMasterKey = new System.Windows.Forms.TextBox();
			this.btnSave = new System.Windows.Forms.Button();
			this.btnLoad = new System.Windows.Forms.Button();
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.txtPlainText = new System.Windows.Forms.TextBox();
			this.label4 = new System.Windows.Forms.Label();
			this.txtCipherText = new System.Windows.Forms.TextBox();
			this.btnEncrypt = new System.Windows.Forms.Button();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.SuspendLayout();
			// 
			// groupBox1
			// 
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Controls.Add(this.btnLoad);
			this.groupBox1.Controls.Add(this.btnSave);
			this.groupBox1.Controls.Add(this.txtMasterKey);
			this.groupBox1.Controls.Add(this.txtRegistryKey);
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(424, 160);
			this.groupBox1.TabIndex = 0;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Master Key";
			// 
			// groupBox2
			// 
			this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox2.Controls.Add(this.btnEncrypt);
			this.groupBox2.Controls.Add(this.label4);
			this.groupBox2.Controls.Add(this.txtCipherText);
			this.groupBox2.Controls.Add(this.label3);
			this.groupBox2.Controls.Add(this.txtPlainText);
			this.groupBox2.Location = new System.Drawing.Point(8, 172);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(424, 156);
			this.groupBox2.TabIndex = 1;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Encrypt String";
			// 
			// txtRegistryKey
			// 
			this.txtRegistryKey.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRegistryKey.Location = new System.Drawing.Point(16, 40);
			this.txtRegistryKey.Name = "txtRegistryKey";
			this.txtRegistryKey.Size = new System.Drawing.Size(392, 20);
			this.txtRegistryKey.TabIndex = 0;
			this.txtRegistryKey.Text = "SOFTWARE\\HannesFoulds\\encryption,masterkey";
			// 
			// txtMasterKey
			// 
			this.txtMasterKey.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtMasterKey.Location = new System.Drawing.Point(16, 88);
			this.txtMasterKey.Name = "txtMasterKey";
			this.txtMasterKey.Size = new System.Drawing.Size(392, 20);
			this.txtMasterKey.TabIndex = 1;
			this.txtMasterKey.Text = "";
			// 
			// btnSave
			// 
			this.btnSave.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSave.Location = new System.Drawing.Point(256, 120);
			this.btnSave.Name = "btnSave";
			this.btnSave.TabIndex = 2;
			this.btnSave.Text = "&Save";
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			// 
			// btnLoad
			// 
			this.btnLoad.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnLoad.Location = new System.Drawing.Point(336, 120);
			this.btnLoad.Name = "btnLoad";
			this.btnLoad.TabIndex = 3;
			this.btnLoad.Text = "&Load";
			this.btnLoad.Click += new System.EventHandler(this.btnLoad_Click);
			// 
			// label1
			// 
			this.label1.AutoSize = true;
			this.label1.Location = new System.Drawing.Point(16, 24);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(71, 16);
			this.label1.TabIndex = 4;
			this.label1.Text = "Registry Key:";
			// 
			// label2
			// 
			this.label2.AutoSize = true;
			this.label2.Location = new System.Drawing.Point(16, 72);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(64, 16);
			this.label2.TabIndex = 5;
			this.label2.Text = "Master Key:";
			// 
			// label3
			// 
			this.label3.AutoSize = true;
			this.label3.Location = new System.Drawing.Point(16, 24);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(58, 16);
			this.label3.TabIndex = 6;
			this.label3.Text = "Plain Text:";
			// 
			// txtPlainText
			// 
			this.txtPlainText.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPlainText.Location = new System.Drawing.Point(16, 40);
			this.txtPlainText.Name = "txtPlainText";
			this.txtPlainText.Size = new System.Drawing.Size(392, 20);
			this.txtPlainText.TabIndex = 5;
			this.txtPlainText.Text = "";
			// 
			// label4
			// 
			this.label4.AutoSize = true;
			this.label4.Location = new System.Drawing.Point(16, 72);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(66, 16);
			this.label4.TabIndex = 8;
			this.label4.Text = "Cipher Text:";
			// 
			// txtCipherText
			// 
			this.txtCipherText.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtCipherText.Location = new System.Drawing.Point(16, 88);
			this.txtCipherText.Name = "txtCipherText";
			this.txtCipherText.ReadOnly = true;
			this.txtCipherText.Size = new System.Drawing.Size(392, 20);
			this.txtCipherText.TabIndex = 7;
			this.txtCipherText.Text = "";
			// 
			// btnEncrypt
			// 
			this.btnEncrypt.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnEncrypt.Location = new System.Drawing.Point(336, 120);
			this.btnEncrypt.Name = "btnEncrypt";
			this.btnEncrypt.TabIndex = 12;
			this.btnEncrypt.Text = "&Encrypt";
			this.btnEncrypt.Click += new System.EventHandler(this.btnEncrypt_Click);
			// 
			// EncryptionForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(440, 339);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.groupBox1);
			this.Name = "EncryptionForm";
			this.Text = "Data Protection";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Main
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new EncryptionForm());
		}
		#endregion

		#region Event Handlers
		/// <summary>
		/// The event handler that should execute when a master key must be saved in the registry.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.encryptionEngine.RegistryKey = this.txtRegistryKey.Text;
				this.encryptionEngine.MasterKey = this.txtMasterKey.Text;
				this.encryptionEngine.SaveMasterKey();
				MessageBox.Show(this, "The Master Key was stored in the registry.", "Saved", MessageBoxButtons.OK, MessageBoxIcon.Information);
			}
			catch(Exception ex)
			{
				MessageBox.Show(this, ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		#endregion

		/// <summary>
		/// The event handler that loads the master key from the registry.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnLoad_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.encryptionEngine.RegistryKey = this.txtRegistryKey.Text;
				this.encryptionEngine.LoadMasterKey();

				this.txtMasterKey.Text = this.encryptionEngine.MasterKey;
			}
			catch(Exception ex)
			{
				MessageBox.Show(this, ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}

		private void btnEncrypt_Click(object sender, System.EventArgs e)
		{
			try
			{
				this.encryptionEngine.MasterKey = this.txtMasterKey.Text;
				this.encryptionEngine.PlainText = this.txtPlainText.Text;
				this.encryptionEngine.EncryptString();

                this.txtCipherText.Text = this.encryptionEngine.CipherText;
			}
			catch(Exception ex)
			{
				MessageBox.Show(this, ex.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
	}
}
