/*	
   
    - - - - - - - - - - - - - - - - - - - - - - -
    File Name : EmployeeDL.cs
    - - - - - - - - - - - - - - - - - - - - - - -

    System				    :  	Project
    Module				    :  	DataAccess Layer
    Author				    :	Shyam SS
    Date					:	28 June 2007
    Function				:	Define the DataAccess Class.
    Description	            :   Examples for the major functionalites. 
                                These examples just define the implementation of DBHelper methods.

   
 */

#region DIRECTIVE

using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.Common;
using System.Collections;
using Entity;   // Include reference to Entity dll.
using DBHelper; // Include reference to the DBHelper dll.

#endregion

namespace Web.DataAccess
{
    public class EmployeeDL
    {

        #region TIPS USING DBHelper 

        // Parameter Related - Execute Methods accepts two types of Parameter Array - Object, Structure

        // Object Parameter Array accepts only Parameter Name and Value 
        // object[,] colParameters = new object[,] { { "@DEPARTMENTID", oDepartment.Id } }; 

        // Struct Parameter Array have two constructors which accepts Parameter NAme, Value and Direction
        // Without Parameter Direction
        // ArrayList colParameters = new DBHelper.Parameters[] { new DBHelper.Parameters("@DEPARTMENTID",  oDepartment.Id ) }; 
        // With Parameter Direction
        // ArrayList colParameters = new DBHelper.Parameters[] { new DBHelper.Parameters("@DEPARTMENTID",  oDepartment.Id, ParameterDirection.Output ) }; 
        
        #endregion

        #region EXECUTESCLAR METHOD 

        public int GetEmployeeCount(Entity.Department oDepartment)
        {
            DBHelper oDBHelper = null;

            try
            {

                object[,] colParameters = new object[,] { { "@DEPARTMENTID", oDepartment.Id } };  // Object Parameter Array
                oDBHelper               = new DBHelper();
                return  Convert.ToInt32(oDBHelper.ExecuteScalar(CommandType.Text, 
                                        "select dbo.UDF_EMPLOYEECOUNT_SELECT(@DEPARTMENTID)", colParameters));
                
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                oDBHelper = null;
            }
        }

        #endregion

        #region EXECUTEREADER METHOD 

        public IList<Entity.Employee> GetEmployeeDetails(Entity.Department oDepartment)
        {
            IList<Entity.Employee> oList    = null;
            Entity.Employee oEmployee       = null;
            DBHelper oDBHelper              = null;
            ArrayList colParameters         = null;

            try
            {

                colParameters       = new DBHelper.Parameters[] 
                                            { new DBHelper.Parameters("@DEPARTMENTID",  oDepartment.Id) }; // Structure Parameter Array
                oDBHelper           = new DBHelper();

                using ( IDataReader drEmployee = oDBHelper.ExecuteReader( CommandType.StoredProcedure, "USP_EMPLOYEE_SELECT", colParameters ) )
                {
                    oList   = new List<Entity.Employee>();

                    //Reading the reader one by one and setting into requestTypeInfo.
                    while (drEmployee.Read())
                    {
                        oEmployee   = new Entity.Employee();

                        oEmployee.Id            = drEmployee["EMPLOYEEID"].ToString();
                        oEmployee.Name          = drEmployee["EMPLOYEENAME"].ToString();
                        oEmployee.Designation   = drEmployee["DESIGNATION"].ToString();

                        oList.Add(oEmployee);
                        oEmployee   = null;
                    }
                }

                return oList;
            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                colParameters   = null;
                oDBHelper       = null;
            }
        }
        
        #endregion

        #region EXECUTENONQUERY METHOD 

        public void Save(Entity.Employee oEmployee)
        {

            DBHelper oDBHelper          = null;
            ArrayList colParameters     = null;
            
            try
            {

                colParameters   = new DBHelper.Parameters[] 
                                    { 
                                        new DBHelper.Parameters( "@EMPLOYEEID",     oEmployee.Id, ParameterDirection.Output ),
                                        new DBHelper.Parameters( "@EMPLOYEENAME",   oEmployee.Name ),
                                        new DBHelper.Parameters( "@DESIGNATIONID",  oEmployee.Designation )                                    
                                    };
                oDBHelper       = new DBHelper();
                oDBHelper.ExecuteNonQuery(CommandType.StoredProcedure, "USP_EMPLOYEE_SAVE", colParameters);
                oEmployee.Id    = Int32.Parse((((IDataParameter)oDBHelper.oCommand.Parameters["@EMPLOYEEID"]).Value).ToString());

            }
            catch (Exception ex)
            {
                throw ex;
            }
            finally
            {
                colParameters   = null;
                oDBHelper       = null;
            }
        }

        #endregion

        #region EXECUTENONQUERY METHOD IN TRANSACTION 

        public void Delete(Entity.Employee oEmployee)
        {

           DBHelper oDBHelper   = null;

            try
            {
                object[,] colParameters = new object[,] {   { "@EMPLOYEEID", oEmployee.EmployeeId } };

                oDBHelper               = new DBHelper();
                oDBHelper.EstablishFactoryConnection(); // Open Connection

                // "DBHelper.TransactionType" is an enumerator to set the mode of Transaction- Open, Commit or Rollback
                // TransactionHandler() imethod helps to invoke the Transaction related methods.
                oDBHelper.TransactionHandler(DBHelper.TransactionType.Open); // Open Transaction
                oDBHelper.ExecuteNonQuery(CommandType.StoredProcedure, "USP_EMPLOYEE_DELETE", colParameters);// Executing query
                oDBHelper.TransactionHandler(DBHelper.TransactionType.Commit); // Commit Transaction

            }
            catch (Exception ex)
            {
                oDBHelper.TransactionHandler(DBHelper.TransactionType.Rollback); // Rollback Transaction
                throw ex;
            }
            finally
            {
                oDBHelper.CloseFactoryConnection(); // Close Connection
                oDBHelper   = null;
            }

        }

        #endregion

    }
}
