using System;
using System.Data; 
using System.Collections.Generic;
using System.Text;
using MySql.Data;
using MySql.Data.MySqlClient;
using MySql.Data.Types;
using System.Configuration;
using System.IO;


namespace Website.Data
{
    public sealed class DataAccess
    {
        private DataAccess()
        {}   
            
        #region MYSQLCONNECTION

        /// <summary>
        /// This method gets the connection string.
        /// </summary>
        /// <returns>Connection String</returns>
        private static string GetConnectionString()
        {
            try
            {
                string strReturnConnectionString;

                /* This code takes connection string from the web.config file.*/

                strReturnConnectionString = ConfigurationManager.ConnectionStrings["MySqlConnectionString"].ConnectionString.ToString();        

                return strReturnConnectionString;
            }
            catch (Exception Ex)
            {
                throw Ex; 
            }
        }
        

        /// <summary>
        /// This method returns MySqlConnection object.
        /// </summary>
        /// <returns>MySqlConnection</returns>
        private static MySqlConnection GetMysqlConnection()
        {
            try
            {
                string strConnection;
                strConnection = GetConnectionString();
                MySqlConnection mySqlConnection = new MySqlConnection(strConnection);
                return mySqlConnection;
            }
            catch (Exception Ex)
            {
                throw Ex; 
            }

        }

        #endregion


        #region EXECUTE DATASET

        /// <summary>
        /// This method returns the data in dataset form. 
        /// </summary>
        /// <param name="cmdType">Command type</param>
        /// <param name="cmdText">Command text</param>
        /// <returns>Data in the form of Dataset.</returns>
        /// <summary>
        public static DataSet ExecuteDataSet(CommandType cmdType, string CommandText)
        {
            try
            {
                DataSet dsData = new DataSet();
                MySqlDataAdapter myDataAdapter = new MySqlDataAdapter(); 
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = GetMysqlConnection();
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                myDataAdapter.SelectCommand = myCommand;
                myDataAdapter.Fill(dsData);
                return dsData; 
            }
            catch(Exception Ex)
            {
                throw Ex;
            }
        }


        /// <summary>
        /// This method returns the data in dataset form. 
        /// </summary>
        /// <param name="cmdType">Command type</param>
        /// <param name="cmdText">Command text</param>
        /// <param name="mysqlParams">MySqlParameters</param>
        /// <returns>Data in the form of Dataset.</returns>
        public static DataSet ExecuteDataSet(CommandType cmdType, string CommandText, MySqlParameter[] mysqlParams)
        {
            try
            {
                DataSet dsData = new DataSet();
                MySqlDataAdapter myDataAdapter = new MySqlDataAdapter();
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = GetMysqlConnection();
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;

                for (int i = 0; i < mysqlParams.Length; i++)
                {
                    myCommand.Parameters.Add(mysqlParams[i]);
                }

                myDataAdapter.SelectCommand = myCommand;
                myDataAdapter.Fill(dsData);
                return dsData;
            }
            catch (Exception Ex)
            {
                throw Ex;
            }
        }

        #endregion


        #region EXECUTE SCALAR
                     

        /// <summary>
        /// This method returns object typecast the object to int or string depending upon return type.
        /// </summary>
        /// <param name="cmdType">CommandType</param>
        /// <param name="CommandText">CommandText</param>
        /// <returns>Object</returns>
        public static object ExecuteScalar(CommandType cmdType, string CommandText)
        {
            object objValue;
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection;
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                mySqlConnection.Open();
                objValue = myCommand.ExecuteScalar();
                return objValue;

            }
            catch (Exception Ex)
            {
                throw Ex;
            }
            finally
            {
                mySqlConnection.Close();
            }
           
        }


        /// <summary>
        /// This method returns object typecast the object to int or string depending upon return type.
        /// </summary>
        /// <param name="cmdType">CommandType</param>
        /// <param name="CommandText">CommandText</param>
        /// <param name="mysqlParams">MySqlParameter</param>
        /// <returns>Object</returns>
        public static object ExecuteScalar(CommandType cmdType, string CommandText, MySqlParameter[] mysqlParams)
        {
            object objValue;
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection;
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                for (int i = 0; i < mysqlParams.Length; i++)
                {
                    myCommand.Parameters.Add(mysqlParams[i]);
                }
                mySqlConnection.Open();
                objValue = myCommand.ExecuteScalar();
                return objValue;

            }
            catch (Exception Ex)
            {
                throw Ex;
            }
            finally
            {
                mySqlConnection.Close();
            }

        }
               

        #endregion


        #region EXECUTE NONQUERY

        /// <summary>
        /// This methods returns no of rows affected.
        /// </summary>
        /// <param name="cmdType">CommandType</param>
        /// <param name="CommandText">CommandText</param>
        /// <returns></returns>
        public static int ExecuteNonQuery(CommandType cmdType, string CommandText)
        {
            int intRValue;
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {            
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection; 
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                mySqlConnection.Open();
                MySqlTransaction mySqlTransaction = mySqlConnection.BeginTransaction();
                intRValue = myCommand.ExecuteNonQuery();
                mySqlTransaction.Commit();  
                return intRValue;
              
            }
            catch (Exception Ex)
            {
                throw Ex; 
            }
            finally
            {
                mySqlConnection.Close();
            }

        }


        /// <summary>
        /// /// This methods returns no of rows affected.
        /// </summary>
        /// <param name="cmdType">CommandType</param>
        /// <param name="CommandText">CommandText</param>
        /// <param name="mysqlParams">MySqlParameters</param>
        /// <returns></returns>
        public static int ExecuteNonQuery(CommandType cmdType, string CommandText, MySqlParameter[] mysqlParams)
        {
            int intRValue;
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection;
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                for (int i = 0; i < mysqlParams.Length; i++)
                {
                    myCommand.Parameters.Add(mysqlParams[i]);
                }
                
                mySqlConnection.Open();

                MySqlTransaction mySqlTransaction = mySqlConnection.BeginTransaction();
                intRValue = myCommand.ExecuteNonQuery();
                mySqlTransaction.Commit();  
                               
                return intRValue;

            }
            catch (Exception Ex)
            {
                throw Ex;
            }
            finally
            {
                mySqlConnection.Close();
            }

        }

        #endregion


        #region EXECUTE READER

        /// <summary>
        /// This method returns data in form of reader form.
        /// </summary>
        /// <param name="cmdType">Command Type</param>
        /// <param name="CommandText">Command Text</param>
        /// <returns></returns>
        public static MySqlDataReader ExecuteReader(CommandType cmdType, string CommandText)
        {
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {
                MySqlDataReader mySqlDataReader; 
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection;                  
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                mySqlConnection.Open();
                mySqlDataReader = myCommand.ExecuteReader();
                return mySqlDataReader;

            }
            catch (Exception Ex)
            {
                throw Ex;
            }
        }



        /// <summary>
        /// This method returns data in form of reader form.
        /// </summary>
        /// <param name="cmdType">Command Type</param>
        /// <param name="CommandText">Command Text</param>
        /// <param name="mysqlParams">MYSQLPARAMETERS</param>
        /// <returns></returns>
        public static MySqlDataReader ExecuteReader(CommandType cmdType, string CommandText, MySqlParameter[] mysqlParams)
        {
            MySqlConnection mySqlConnection = GetMysqlConnection();
            try
            {
                MySqlDataReader mySqlDataReader;
                MySqlCommand myCommand = new MySqlCommand();
                myCommand.Connection = mySqlConnection;
                myCommand.CommandType = cmdType;
                myCommand.CommandText = CommandText;
                for (int i = 0; i < mysqlParams.Length; i++)
                {
                    myCommand.Parameters.Add(mysqlParams[i]);
                }

                mySqlConnection.Open();
                mySqlDataReader = myCommand.ExecuteReader();
                return mySqlDataReader;

            }
            catch (Exception Ex)
            {
                throw Ex;
            }
        }

        #endregion
    }

  
}
