using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Website.Data;
using MySql.Data.MySqlClient;  

 

namespace TestWebApplication
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            /*Call BindData 1,2,3,4*/
            BindData();  
        }

        /// <summary>
        /// This method demonstrates ExecuteDataset passing CommandType as Store Procedure and CommandText as Store Procedure Name.
        /// </summary>
        protected void BindData()
        {
            try
            {
                 DataSet dsEmployee = new DataSet();
                 dsEmployee = DataAccess.ExecuteDataSet(CommandType.StoredProcedure, "EmployeeDetails");
                 grdViewEmployee.DataSource = dsEmployee;
                 grdViewEmployee.DataBind();
                                
                 
            }
            catch
            { 
            }
        }

        /// <summary>
        /// This method demonstrates ExecuteDataset by passing CommandType as Text and CommandText as Query.
        /// </summary>
        protected void BindData1()
        {
            try
            {
                DataSet dsEmployee = new DataSet();
                dsEmployee = DataAccess.ExecuteDataSet(CommandType.Text, "Select * from employee");
                grdViewEmployee.DataSource = dsEmployee;
                grdViewEmployee.DataBind();
            }
            catch
            {
            }
        }

        /// <summary>
        /// This method demonstrates ExecuteDataset passing CommandType as Store Procedure and CommandText as Store Procedure Name and Store Procedure Parameters.
        /// </summary>
        protected void BindData2()
        {
            try
            {
                DataSet dsEmployee = new DataSet();
                 
                MySqlParameter[] mySqlParams = new MySqlParameter[1];
                mySqlParams[0] = new MySqlParameter();
                mySqlParams[0].ParameterName = "?EmpId";
                mySqlParams[0].Value = 2;

                dsEmployee = DataAccess.ExecuteDataSet(CommandType.StoredProcedure, "EmployeeDetails",mySqlParams);
                grdViewEmployee.DataSource = dsEmployee;
                grdViewEmployee.DataBind();
                              
            }
            catch
            {
            }
        }

        /// <summary>
        /// This method demonstrates ExecuteDataset by passing CommandType as Text and CommandText as Query and Query Parameters.
        /// </summary>
        protected void BindData3()
        {
            try
            {
                DataSet dsEmployee = new DataSet();

                MySqlParameter[] mySqlParams = new MySqlParameter[1];
                mySqlParams[0] = new MySqlParameter();
                mySqlParams[0].ParameterName = "?EmpId";
                mySqlParams[0].Value = 2;

                dsEmployee = DataAccess.ExecuteDataSet(CommandType.Text, "Select * from employee where Id =?EmpId", mySqlParams);
                grdViewEmployee.DataSource = dsEmployee;
                grdViewEmployee.DataBind();

            }
            catch
            {
            }
        }

        /// <summary>
        /// This methods demonstrates Execute Scalar.
        /// </summary>
        protected void btnEmployee_Click(object sender, EventArgs e)
        {
            try
            {
                object objName;
                MySqlParameter[] mySqlParams = new MySqlParameter[1];
                mySqlParams[0] = new MySqlParameter();
                mySqlParams[0].ParameterName = "?EmpId";
                mySqlParams[0].Value = txtEmpId.Text;

                objName = DataAccess.ExecuteScalar(CommandType.Text, "Select Emp_Name from employee where Id =?EmpId", mySqlParams);
                lblEmpName.Text = (string)objName;    
            }
            catch
            { 
            }
        }


        /// <summary>
        /// This methods demonstrates Execute NonQuery.
        /// </summary>
        protected void Update(object sender, EventArgs e)
        {
            try
            {
                if (txtEName.Text != "" & txtEId.Text  != "")
                {
                    string strQuery = " UPDATE employee  " +
                                       " SET Emp_Name = ?EmpName " +
                                       " WHERE Id =?EmpId";

                    MySqlParameter[] mySqlParams = new MySqlParameter[2];
                    mySqlParams[0] = new MySqlParameter();
                    mySqlParams[0].ParameterName = "?EmpName";
                    mySqlParams[0].Value = txtEName.Text;

                    mySqlParams[1] = new MySqlParameter();
                    mySqlParams[1].ParameterName = "?EmpId";
                    mySqlParams[1].Value = txtEId.Text;

                    DataAccess.ExecuteNonQuery(CommandType.Text, strQuery, mySqlParams);

                    BindData();
                }
                                
            }
            catch 
            {
            }
        }

      
                
    }
}
