using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;
using Microsoft.VisualStudio.WebHost;

namespace WebRunner
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }
        private string wins;
        private void button1_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() != DialogResult.OK)
                return;
            textBox1.Text = folderBrowserDialog1.SelectedPath;
        }        
        private Server s;
        private void button2_Click(object sender, EventArgs e)
        {
            try
            {
                int port = int.Parse(textBox2.Text);
                if (textBox1.Text == "")
                {
                    MessageBox.Show("Select a path", "Web Runner", MessageBoxButtons.OK, MessageBoxIcon.Error);
                    return;
                }
                s = new Server(port, textBox3.Text, textBox1.Text);
                s.Start();
                linkLabel1.Text = s.RootUrl;
                pictureBox1.Image = global::WebRunner.Properties.Resources.server;                
            }
            catch (FormatException)
            {
                MessageBox.Show("You Must Enter a Number between 1 t 65535 \n", "Web Runner", MessageBoxButtons.OK, MessageBoxIcon.Error);
                textBox2.Text = "8080";

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }            

        }

        private void button3_Click(object sender, EventArgs e)
        {
            try
            {
                if (s == null)
                    return;
                s.Stop();
                linkLabel1.Text = "";
                pictureBox1.Image = global::WebRunner.Properties.Resources.off_server;


            }
            catch (Exception ex)
            {

                MessageBox.Show(ex.Message);
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {            
            dlgAbout d = new dlgAbout();
            d.ShowDialog();
        }        

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            if (WindowState == FormWindowState.Minimized)
            {
                this.Hide();
                notifyIcon1.Visible = true;
                if (linkLabel1.Text == "")
                    notifyIcon1.BalloonTipText = "Out Of Service";
                else
                    notifyIcon1.BalloonTipText = linkLabel1.Text;
                notifyIcon1.ShowBalloonTip(200);
            }
        }

        private void showToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Show();
            notifyIcon1.Visible = false;
            this.WindowState = FormWindowState.Normal;
        }

        private void sToolStripMenuItem_Click(object sender, EventArgs e)
        {
            button3_Click(sender, e);
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {          
            dlgAbout d = new dlgAbout();
            d.StartPosition = FormStartPosition.CenterScreen;
            d.ShowDialog();
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }        
                      

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start(linkLabel1.Text);
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            showToolStripMenuItem_Click(sender, e);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult r = MessageBox.Show("Are you a want to Close Host?", "Web Runner", MessageBoxButtons.YesNo, MessageBoxIcon.Question);
            if (r == DialogResult.Yes)
                sToolStripMenuItem_Click(sender, e);
            else
            {
                e.Cancel = true;
                return;
            }
            e.Cancel = false;
        }

        private void notifyIcon1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button==MouseButtons.Left)
                notifyIcon1.ShowBalloonTip(200);
        }

        private void notifyIcon1_BalloonTipClicked(object sender, EventArgs e)
        {
            if (linkLabel1.Text != "")
                Process.Start(linkLabel1.Text);
        }
    }
}