using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;

namespace TagSinj
{
    public class TagSinj
    {
        public static string AccessCode = "";

        /// <summary>
        /// This method takes a link and appends to it the secure hash used to validate the query string
        /// </summary>
        /// <param name="link">link</param>
        /// <returns>input link with mac paramater appended</returns>
        public static string generateSecureLink(string link)
        {
            string toHash = "";
            string[] querystring = null;
            string[] vars = null;
            string[] vals = null;
            if (link.Contains("?"))
            {
                querystring = link.Split('?'); vars = querystring[1].Split('&');
                foreach (string st in vars)
                {
                    vals = st.Split('=');
                    toHash += vals[1].ToString();
                }
            }
            else
            {
                querystring = link.Split('?');
                vars = querystring[1].Split('=');
                toHash += vals[1].ToString();
            }
            string hashed = TagSinj.Hash(toHash + TagSinj.AccessCode);
            return link + "&mac=" + hashed;
        }
        /// <summary>
        /// This function takes a string and return the equivalent MD5
        /// </summary>
        /// <param name="toEncrypt">string to hash</param>
        /// <returns>MD5 String</returns>
        private static string Hash(string toEncrypt)
        {
            System.Security.Cryptography.MD5 md5 = System.Security.Cryptography.MD5.Create();
            string encrypted = BitConverter.ToString(md5.ComputeHash(System.Text.Encoding.ASCII.GetBytes(toEncrypt))).Replace("-", String.Empty).ToLower();

            return encrypted;
        }
        /// <summary>
        /// This method takes an HttpRequest as a parameter and checks whether the query string parameters have been
        /// manipulated by the user
        /// </summary>
        /// <param name="Request">HttpRequest, used to take the querystring item</param>
        /// <returns>true if query string is authentic, false otherwise</returns>
        public static bool validateLink(HttpRequest Request)
        {
            try
            {
                if (Request.QueryString.Count > 0)
                {
                    String[] queryKeys = Request.QueryString.AllKeys;
                    int queryCount = Request.QueryString.Count;

                    string toHash = "";
                    for (int m = 0; m < queryCount; m++)
                    {
                        if (queryKeys[m] != "mac")
                        {
                            toHash += Request.QueryString[queryKeys[m]];
                        }
                    }
                    string hashed = TagSinj.Hash(toHash + TagSinj.AccessCode);
                    if (hashed != Request.QueryString["mac"])
                    {
                        return false;
                    }
                    else
                    {
                        return true;
                    }
                }
                else
                {
                    return false;
                }
            }
            catch
            {
                return false;
            }
        }
    }
}
