Imports System.Data
Imports System.Data.SqlClient

Partial Class _Default
    Inherits System.Web.UI.Page

    Protected Sub DataList1_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.DataListItemEventArgs) Handles DataList1.ItemDataBound
        If e.Item.ItemType = ListItemType.Item Or e.Item.ItemType = ListItemType.AlternatingItem Then
            Dim anstype As HiddenField = e.Item.FindControl("HiddenField1")
            Dim questionid As Label = e.Item.FindControl("Label3")
            Dim rbl As RadioButtonList = e.Item.FindControl("RadioButtonList1")
            Dim cbl As CheckBoxList = e.Item.FindControl("CheckBoxList1")
            Dim txt As TextBox = e.Item.FindControl("TextBox1")
            Dim ds As DataSet = GetDataSet(questionid.Text)
            Select Case anstype.Value
                Case "S"
                    rbl.Visible = True
                    cbl.Visible = False
                    txt.Visible = False
                    rbl.DataSource = ds
                    rbl.DataTextField = "Choice"
                    rbl.DataValueField = "ChoiceID"
                    rbl.DataBind()
                Case "M"
                    rbl.Visible = False
                    cbl.Visible = True
                    txt.Visible = False
                    cbl.DataSource = ds
                    cbl.DataTextField = "Choice"
                    cbl.DataValueField = "ChoiceID"
                    cbl.DataBind()
                Case "T"
                    rbl.Visible = False
                    cbl.Visible = False
                    txt.Visible = True
            End Select
        End If
    End Sub

    Private Function GetDataSet(ByVal id As Integer) As DataSet
        Dim cnn As New SqlConnection(ConfigurationManager.ConnectionStrings("ConnectionString").ConnectionString)
        Dim cmd As New SqlCommand("select * from surveychoices where questionid=@id", cnn)
        Dim p1 As New SqlParameter("@id", id)
        cmd.Parameters.Add(p1)
        Dim da As New SqlDataAdapter
        da.SelectCommand = cmd
        Dim ds As New DataSet
        da.Fill(ds, "choices")
        Return ds
    End Function

    Protected Sub Button1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        For Each item As DataListItem In DataList1.Items
            If item.ItemType = ListItemType.Item Or item.ItemType = ListItemType.AlternatingItem Then
                Dim questionid As Integer
                Dim choiceid As Integer = 0
                Dim choicetext As String = ""
                questionid = CType(item.FindControl("Label3"), Label).Text
                Dim anstype As HiddenField = item.FindControl("HiddenField1")
                Select Case anstype.Value
                    Case "S"
                        Dim rbl As RadioButtonList = item.FindControl("RadioButtonList1")
                        choiceid = rbl.SelectedValue
                        SaveAnswer(questionid, choiceid, "")
                    Case "M"
                        Dim cbl As CheckBoxList = item.FindControl("CheckBoxList1")
                        For i As Integer = 0 To cbl.Items.Count - 1
                            If cbl.Items(i).Selected Then
                                choiceid = cbl.Items(i).Value
                                SaveAnswer(questionid, choiceid, "")
                            End If
                        Next
                    Case "T"
                        Dim txt As TextBox = item.FindControl("TextBox1")
                        choicetext = txt.Text
                        SaveAnswer(questionid, 0, choicetext)
                End Select
            End If
        Next
        DataList1.Visible = False
        Label5.Text = "Thank you for participating in the survey!"
    End Sub

    Private Sub SaveAnswer(ByVal qid As Integer, ByVal cid As Integer, ByVal ct As String)
        Dim cnn As New SqlConnection(ConfigurationManager.ConnectionStrings("ConnectionString").ConnectionString)
        Dim cmd As New SqlCommand("insert into surveyanswers(QuestionID,ChoiceID,ChoiceText) values(@qid,@cid,@ct)", cnn)
        Dim p1 As New SqlParameter("@qid", qid)
        Dim p2 As New SqlParameter("@cid", IIf(cid = 0, DBNull.Value, cid))
        Dim p3 As New SqlParameter("@ct", IIf(ct = "", DBNull.Value, ct))
        cmd.Parameters.Add(p1)
        cmd.Parameters.Add(p2)
        cmd.Parameters.Add(p3)
        cnn.Open()
        cmd.ExecuteNonQuery()
        cnn.Close()
    End Sub
End Class
