using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Drawing;
using System.Drawing.Design;

namespace EmbedFlash
{
    public enum FlashWMode 
    {
        Windowed, Opaque, Transparent
    }

    [DefaultProperty("Text")]
    [ToolboxData("<{0}:EmbedFlashControl runat=server></{0}:EmbedFlashControl>")]
    public class EmbedFlashControl : WebControl
    {
        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        public string Text
        {
            get
            {
                String s = (String)ViewState["Text"];
                return ((s == null) ? String.Empty : s);
            }

            set
            {
                ViewState["Text"] = value;
            }
        }

        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]
        [Localizable(true)]
        [Description("Absolute or relative URL for Flash object")]
        [EditorAttribute(typeof(System.Web.UI.Design.UrlEditor), typeof(UITypeEditor))]
        public string SWFURL
        {
            get
            {
                String s = (String)ViewState["SWFURL"];
                return ((s == null) ? String.Empty : s);
            }
            set
            {
                ViewState["SWFURL"] = value;
            }
        }

        [
        Category("Appearance"),
        Browsable(true)
        ]
        public FlashWMode WMode
        {
            get
            {
                return (FlashWMode)(ViewState["WMode"] ?? (FlashWMode.Opaque));
            }
            set
            {
                ViewState["WMode"] = value;
            }
        }

        public override Unit  Width
        {
	        get 
	        {
                Unit res = base.Width;
                if(res==Unit.Empty) res = new Unit(550);
		        return res;
	        }
	        set 
	        { 
		        base.Width = value;
	        }
        }


        public override Unit Height
        {
            get
            {
                Unit res = base.Height;
                if (res == Unit.Empty) res = new Unit(400);
                return res;
            }
            set
            {
                base.Height = value;
            }
        }
        
        public bool ShowMenu
        {
            get
            {
                return (bool)(ViewState["ShowMenu"] ?? false);
            }
            set
            {
                ViewState["ShowMenu"] = value;
            }
        }

        public override Color BackColor
        {
            get
            {
                Color res = base.BackColor.IsEmpty?Color.White:base.BackColor;
                
                return res;
            }
            set
            {
                base.BackColor = value;
            }
        }
       
        protected bool isIE
        {
            get
            {
                bool res = false;
                if(!this.DesignMode) res = (Page.Request.Browser.Browser.IndexOf("IE") > -1);
                return res;
            }
        }

        public override void RenderBeginTag(HtmlTextWriter writer)
        {
        }

        public override void RenderEndTag(HtmlTextWriter writer)
        {
        }

        protected override void OnLoad(EventArgs e)
        {
            
            // Add Script File in case of IE //
            if (isIE) ScriptManagerHelper.RegisterClientScriptResource(this, this.GetType(), "EmbedFlash.activate.js");
            base.OnLoad(e);
        }

        protected override void RenderContents(HtmlTextWriter output)
        {
            string html = "";

            string client_sfwurl = Page.ResolveClientUrl(SWFURL);
            if (SWFURL != "")
            {
                string obj = "";
                obj += "<OBJECT classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"";
                obj += " codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\"";
                obj += " ID=\""+this.ClientID+"\" WIDTH=\"" + this.Width.ToString() + "\" HEIGHT=\"" + this.Height.ToString() + "\" ALIGN=\"\">";
                obj += "<PARAM NAME=movie VALUE=\"" + client_sfwurl + "\">";
                obj += "<PARAM NAME=menu VALUE=" + ShowMenu.ToString().ToLower() + ">";
                obj += "<PARAM NAME=quality VALUE=high><PARAM NAME=bgcolor VALUE=" + ColorTranslator.ToHtml(this.BackColor) + ">";
                obj += "<EMBED src=\""+client_sfwurl+"\" menu=" + ShowMenu.ToString().ToLower() + " quality=high bgcolor=\"" + ColorTranslator.ToHtml(this.BackColor) + "\"  WIDTH=\"" + Width.ToString() + "\" HEIGHT=\"" + Height.ToString() + "\" swLiveConnect=true ID=\""+this.ClientID+"\" NAME=\""+this.ClientID+"\" ALIGN=\"\" TYPE=\"application/x-shockwave-flash\" PLUGINSPAGE=\"http://www.macromedia.com/go/getflashplayer\"></EMBED>";
                obj += "</OBJECT>";

                if (isIE)
                {
                    //ScriptManagerHelper.RegisterClientScriptResource(this, this.GetType(), "EmbedFlash.activate.js");
                    html += "<div id=" + this.ClientID+"cnt" + "></div>";
                    html += "<script language='javascript'>\n";
                    html += "ActivateFlash('" + this.ClientID+"cnt" + "','" + obj + "');\n";
                    html += "</script>\n";
                }
                else
                {
                    html = obj;
                }
            }
            else
            {
                html = "<span id='" + this.ClientID + "'>Adobe Flash Object "+"</span>";
            }
            //output.Write(Page.ClientScript.GetWebResourceUrl(this.GetType(),"EmbedFlash.activate.js"));
            output.Write(html);
        }
    }
}
