/*
 * Decompiled with CFR 0.152.
 */
import java.applet.AudioClip;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Hashtable;
import java.util.Stack;

public class RealMedia
extends Component
implements Runnable {
    private Loadable lb;
    private Hashtable htImage;
    private Hashtable htsound;
    private Stack st1;
    private Stack st2;
    private int delay;
    private int size;
    private boolean loadFlag = true;
    private MediaTracker mt;
    private boolean loading;
    private Thread pauseThread;

    public RealMedia(Loadable loadable) {
        this.lb = loadable;
        this.htImage = new Hashtable();
        this.htsound = new Hashtable();
        this.st1 = new Stack();
        this.st2 = new Stack();
        this.mt = new MediaTracker(this);
        this.pauseThread = new Thread(this);
        this.setDelay(40);
    }

    public void add(String string, String string2) {
        this.st1.push(this.getMedia(string));
        this.st2.push(string2);
    }

    public void addImage(String string, int n) {
        this.st1.push(this.getMedia(string));
        this.st2.push(string);
    }

    public Image get(String string) {
        return (Image)this.htImage.get(string);
    }

    public int getCurrent() {
        return this.size - this.st1.size() + 1;
    }

    private Object getMedia(String string) {
        if (this.isAudio(string)) {
            return new String(string);
        }
        return this.lb.loadImage(string);
    }

    public int getPercent() {
        return (int)((double)this.getCurrent() / (double)this.size * 100.0);
    }

    public int getTotalFiles() {
        return this.size;
    }

    private boolean isAudio(String string) {
        return string.endsWith(".au");
    }

    public boolean isLoaded() {
        return this.st1.empty();
    }

    public void load() {
        this.size = this.st1.size();
        this.pauseThread.start();
    }

    private void loadNext() {
        if (!this.st1.empty() && !this.loading) {
            this.loading = true;
            this.mt = new MediaTracker(this);
            Object var1_1 = null;
            String string = "";
            var1_1 = this.st1.pop();
            string = (String)this.st2.pop();
            if (var1_1 instanceof Image) {
                this.mt.addImage(var1_1, 0);
                this.htImage.put(string, var1_1);
            } else if (var1_1 instanceof String) {
                this.htsound.put(string, this.lb.loadAudio(var1_1));
            }
            try {
                this.mt.waitForAll();
            }
            catch (Exception exception) {}
        }
        this.loading = false;
    }

    public void play(String string) {
        AudioClip audioClip = (AudioClip)this.htsound.get(string);
        audioClip.play();
    }

    public void run() {
        while (!this.st1.empty()) {
            this.loadNext();
            this.lb.repaint();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {}
        }
        this.lb.startUp();
        this.pauseThread = null;
        System.out.println("Media Fully Loaded");
    }

    public void setDelay(int n) {
        this.delay = n;
    }
}

