/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ReadMe
extends Canvas
implements MouseListener,
MouseMotionListener,
Runnable {
    private Vector text;
    private Font font1;
    private Font font2;
    private Color color1;
    private Color color2;
    private int width;
    private int height;
    private Color bgcolor;
    private Color fgcolor1;
    private Color fgcolor2;
    private Polygon p1;
    private Polygon p2;
    private boolean active;
    private boolean changed;
    private boolean hot1;
    private boolean hot2;
    private boolean loaded;
    private int screen = 0;
    private Image buff;
    private Graphics g;
    private Thread animThread;
    private boolean alive = true;
    private boolean hot1pressed;
    private boolean hot2pressed;
    private String file;

    public ReadMe(Component component, String string, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.file = string;
        this.font1 = new Font("Arial", 0, 12);
        this.font2 = new Font("Arial", 1, 14);
        this.color1 = new Color(0, 122, 122);
        this.color2 = new Color(122, 122, 0);
        this.fgcolor1 = new Color(0, 122, 122);
        this.fgcolor2 = new Color(0, 122, 0);
        this.bgcolor = new Color(0, 0, 0);
        this.setBackground(this.bgcolor);
        int[] nArray = new int[]{n - 10, n - 20, n - 15};
        int[] nArray2 = new int[]{n2 - 20, n2 - 20, n2 - 10};
        this.p1 = new Polygon(nArray, nArray2, 3);
        int[] nArray3 = new int[]{n - 10, n - 20, n - 15};
        int[] nArray4 = new int[]{20, 20, 10};
        this.p2 = new Polygon(nArray3, nArray4, 3);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.buff = component.createImage(n, n2);
        this.g = this.buff.getGraphics();
    }

    public void delete() {
        this.buff = null;
        this.g = null;
        this.text = null;
        this.alive = false;
    }

    private Vector getLines(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        String string2 = "";
        String string3 = "";
        FontMetrics fontMetrics = this.getFontMetrics(this.font1);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            n = 0;
            String string4 = "";
            while (!bl && stringTokenizer.hasMoreTokens()) {
                string2 = " " + stringTokenizer.nextToken();
                string4 = String.valueOf(string3) + string2;
                n = fontMetrics.stringWidth(string4);
                if (n < this.width - 40 && string2.toUpperCase().indexOf("<BR>") == -1) {
                    string3 = String.valueOf(string3) + "" + string2;
                    continue;
                }
                bl = true;
                string2 = this.removeTags(string2, "<BR>");
            }
            vector.addElement(string3.trim());
            string3 = string2;
        }
        return vector;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.hot1pressed = false;
        this.hot2pressed = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.changed = false;
        if (n > this.width - 30 && n2 > this.height - 30) {
            this.active = true;
            if (!this.hot1) {
                this.changed = true;
            }
            this.hot1 = true;
            this.hot2 = false;
        } else if (n > this.width - 30 && n2 < 30) {
            this.active = true;
            if (!this.hot2) {
                this.changed = true;
            }
            this.hot2 = true;
            this.hot1 = false;
        } else {
            if (this.active) {
                this.changed = true;
            }
            this.active = false;
            this.hot1 = false;
            this.hot2 = false;
        }
        if (this.changed) {
            this.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n > this.width - 30 && n2 > this.height - 30) {
            this.hot1pressed = true;
        } else if (n > this.width - 30 && n2 < 30) {
            this.hot2pressed = true;
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.hot1pressed = false;
        this.hot2pressed = false;
    }

    public void paint(Graphics graphics) {
        this.g.setColor(this.bgcolor);
        this.g.fillRect(0, 0, this.width, this.height);
        int n = 10;
        this.g.setColor(this.fgcolor1);
        if (this.hot1) {
            this.g.setColor(this.fgcolor2);
        }
        this.g.fillPolygon(this.p1);
        this.g.setColor(this.fgcolor1);
        if (this.hot2) {
            this.g.setColor(this.fgcolor2);
        }
        this.g.fillPolygon(this.p2);
        this.g.setColor(this.color1);
        if (!this.loaded) {
            this.g.drawString("Loading file...", 20, 20);
            graphics.drawImage(this.buff, 0, 0, this);
            if (this.animThread == null) {
                this.animThread = new Thread(this);
                this.animThread.start();
            }
        } else {
            Enumeration enumeration = this.text.elements();
            while (enumeration.hasMoreElements()) {
                this.g.setColor(this.color1);
                String string = (String)enumeration.nextElement();
                if (string.toUpperCase().indexOf("<H1>") == -1) {
                    this.g.setFont(this.font1);
                    this.g.setColor(this.color1);
                    n += 15;
                } else {
                    this.g.setFont(this.font2);
                    this.g.setColor(this.color2);
                    n += 20;
                }
                string = this.removeTags(string, "<H1>");
                if (this.screen * 5 + n <= -5 || this.screen * 5 + n >= this.height + 10) continue;
                this.g.drawString(string, 10, this.screen * 5 + n);
            }
        }
        this.g.setColor(this.fgcolor1);
        int n2 = 0;
        while (n2 < 4) {
            this.g.setColor(this.g.getColor().brighter());
            this.g.drawRect(n2, n2, this.width - n2 * 2, this.height - n2 * 2);
            ++n2;
        }
        graphics.drawImage(this.buff, 0, 0, this);
    }

    private String readData(String string) {
        int n = 0;
        String string2 = "";
        try {
            InputStream inputStream = new URL(string).openStream();
            while (n != -1) {
                n = inputStream.read();
                if (n == -1) continue;
                string2 = String.valueOf(string2) + (char)n;
            }
            inputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Corrupted data file or file is missing");
        }
        return string2;
    }

    private String removeTags(String string, String string2) {
        int n = string.toUpperCase().indexOf(string2);
        if (n > -1) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n + 4, string.length());
            string = String.valueOf(string3) + string4;
        }
        return string;
    }

    public void run() {
        String string = this.readData(this.file);
        this.text = this.getLines(string);
        this.loaded = true;
        this.repaint();
        while (this.alive) {
            if (this.hot1pressed) {
                --this.screen;
                this.repaint();
            } else if (this.hot2pressed) {
                if (this.screen < 0) {
                    ++this.screen;
                }
                this.repaint();
            }
            try {
                Thread.sleep(60L);
            }
            catch (Exception exception) {}
        }
    }

    public void setFont(Font font, int n) {
        if (n == 1) {
            this.font1 = font;
        } else if (n == 2) {
            this.font2 = font;
        }
    }

    public void setFontColor(Color color, int n) {
        if (n == 1) {
            this.color1 = color;
        } else if (n == 2) {
            this.color2 = color;
        }
    }

    public void setScreenColor(Color color, int n) {
        if (n == 1) {
            this.bgcolor = color;
            this.setBackground(this.bgcolor);
        } else if (n == 2) {
            this.fgcolor1 = color;
        } else if (n == 3) {
            this.fgcolor2 = color;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

