/*  Java - Kitt
	Inspired by the 80's action-series from "The KnightRider"
	The flashing lights are from the car called KITT ( Knight Industries Two Thousand ).

	You may use this source-code for you're own projects, but credits are welcome.

	Author: Gerwin Koudijs

	Email me at gerwinkoudijs@email.com !
*/

import java.awt.*;
import java.applet.*;
import java.awt.event.*;

public class Kitt extends Applet implements Runnable {
	private Thread th;
	Image im;
	Graphics g2;
	Color kleur;
	int[] kl;
	int pos[] = new int[15];
	int dir = 0;
	int var = 1;

	public void init() {
		im = createImage(getSize().width,getSize().height);
		g2 = im.getGraphics();
		setBackground(Color.black);
		kleur = new Color(20,0,0);
		for(int i=0; i<15; i++) {
			pos[i] = 0;
		}
		kl = new int[15];
			for(int i=0; i<15; i++) {
				kl[i] = 0;
		}
		kl[pos[0]] = 225;
	}

	public void start() {
		if(th == null) {
			th = new Thread(this);
			th.start();
		}
	}

	public void stop() {
		if(th != null) {
			th.interrupt();
		}
	}

	public void run() {
		while(true) {
			try {
				th.sleep(100);
			}
			catch(InterruptedException e) {};
			repaint();
			pos[0]+=var;
			if(pos[0] == 14) {
				var = -1;
			}
			if(pos[0] == 0) {
				var = 1;
			}
			int[] posB = new int[15];
			for(int i=0; i<15; i++) {
				posB[i] = pos[i];
			}
			for(int i=1; i<15; i++) {
				posB[i] = pos[i-1];
			}
			for(int i=1; i<15; i++) {
				pos[i] = posB[i];
			}
			for(int i=0; i<15; i++) {
				kl[pos[14-i]] = i * 15;
			}
		}
	}

	public void update(Graphics g) {
		g2.setColor(getBackground());
		g2.fillRect(0,0,getSize().width,getSize().height);
		paint(g);
	}

	public void paint(Graphics g) {
		g2.setColor(Color.red);
		g2.drawRect(10,10,300,20);
		for(int i=0; i<15; i++) {
			kleur = new Color(kl[i],0,0);
			g2.setColor(kleur);
			g2.fillOval(15+(i*20),15,10,10);
		}
		g.drawImage(im,0,0,this);
	}

	public void destroy() {
		g2.dispose();
	}
}
