import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.net.*;
import java.applet.*;

public class Xylophone extends Applet implements MouseMotionListener	{
	static Image xyloImage, malletImage, mdImage, curImage, trebleClefImage, eighthImage, eighthImage2;
	static AudioClip[] acArray;
	static int mx=0, my=0;
	static int curFloor=0, curCeiling=0;
	static int curNote;
	static SongSaver ss;
	static Button playButton, stopButton, deleteButton, deleteLastButton; //play/pause are integrated
	static Choice rhythmChoice, tempoChoice;
//	static MouseListener ml;
	static XyloListener ml;
	static boolean up=true;
	public void init()	{
	    setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	    acArray=new AudioClip[15];
    	xyloImage=getImage(getCodeBase(), "xylo.jpg");
    	malletImage=getImage(getCodeBase(), "mallet.gif");
		mdImage=getImage(getCodeBase(), "mallet_down.gif");
		trebleClefImage=getImage(getCodeBase(), "treble_clef.gif");
		eighthImage=getImage(getCodeBase(), "eighth_note.gif");
		eighthImage2=getImage(getCodeBase(), "eighth_note2.gif");
		curImage=malletImage;
		ss=new SongSaver();
		playButton=new Button("Play");
		stopButton=new Button("Stop");
		deleteButton=new Button("Delete All");
		deleteLastButton=new Button("Delete Last Note");
		rhythmChoice=new Choice();
		rhythmChoice.addItem("Quarter Note");
		rhythmChoice.addItem("Eighth Note");
		rhythmChoice.addItem("Sixteenth Note");
		tempoChoice=new Choice();
		tempoChoice.addItem("100 beats per minute");
		tempoChoice.addItem("80 beats per minute");
		tempoChoice.addItem("60 beats per minute");
		add(playButton);
		add(stopButton);
		add(deleteLastButton);
		add(deleteButton);
		add(rhythmChoice);
		add(tempoChoice);
	    try {
	    	acArray[0]=getAudioClip(getCodeBase(), "x0.au");  
    		acArray[1]=getAudioClip(getCodeBase(), "x1.au");
    		acArray[2]=getAudioClip(getCodeBase(), "x2.au");
    		acArray[3]=getAudioClip(getCodeBase(), "x3.au");
    		acArray[4]=getAudioClip(getCodeBase(), "x4.au");
    		acArray[5]=getAudioClip(getCodeBase(), "x5.au");
    		acArray[6]=getAudioClip(getCodeBase(), "x6.au");
    		acArray[7]=getAudioClip(getCodeBase(), "x7.au");
    		acArray[8]=getAudioClip(getCodeBase(), "x8.au");
    		acArray[9]=getAudioClip(getCodeBase(), "x9.au");
    		acArray[10]=getAudioClip(getCodeBase(), "x10.au");
    		acArray[11]=getAudioClip(getCodeBase(), "x11.au");
    		acArray[12]=getAudioClip(getCodeBase(), "x12.au");
    		acArray[13]=getAudioClip(getCodeBase(), "x13.au");
    		acArray[14]=getAudioClip(getCodeBase(), "x14.au");
	    }	catch(Exception e)	{System.out.println("ALL FILES MUST BE IN THE SAME DIRECTORY");}
	    addMouseMotionListener(this);
	    ml=new XyloListener(this);
//	    ml=new MouseAdapter()	{
//	public void mousePressed(MouseEvent e)	{
//		int x=e.getX();
//		int y=e.getY();
//	if (y<233)	{
//		if (x<60)	{
//			curFloor=-1;	//negative denotes N/A
//			curCeiling=60;
//		}
//		else if (x<93)	{
//			curFloor=60;
//			curCeiling=93;
//		//	curNote=0;
//			if ((y<233) && (y>0))	{
//				acArray[0].play();
//				ss.addNote(0);
//			}
//		}
//		else if (x<125)	{
//			curFloor=93;
//			curCeiling=125;
//		//	curNote=1;
//			if ((y<233) && (y>0))	{
//				acArray[1].play();
//				ss.addNote(1);
//			}
//		}
//		else if (x<158)	{
//			curFloor=125;
//			curCeiling=158;
//			//curNote=2;
//			if ((y<223) && (y>0))	{
//				acArray[2].play();
//				ss.addNote(2);
//			}
//		}
//		else if (x<191)	{
//			curFloor=158;
//			curCeiling=191;
//			//curNote=3;
//			if ((y<220) && (y>0))	{
//				acArray[3].play();
//				ss.addNote(3);
//			}
//		}
//		else if (x<223)	{
//			curFloor=191;
//			curCeiling=223;
//	//		curNote=4;
//			if ((y<218) && (y>0))	{
//				acArray[4].play();
//				ss.addNote(4);
//			}
//		}
//		else if (x<257)	{
//			curFloor=223;
//			curCeiling=257;
//		//	curNote=5;
//			if ((y<215) && (y>0))	{
//				acArray[5].play();
//				ss.addNote(5);
//			}
//		}
//		else if (x<289)	{
//			curFloor=257;
//			curCeiling=289;
//			if ((y<210) && (y>0))	{
//				acArray[6].play();
//				ss.addNote(6);
//			}
//		}
//		else if (x<322)	{
//			curFloor=289;
//			curCeiling=322;
//			if ((y<207) && (y>0))	{
//				acArray[7].play();
//				ss.addNote(7);
//			}
//		}
//		else if (x<354)	{
//			curFloor=322;
//			curCeiling=354;
//			if ((y<206) && (y>0))	{
//				acArray[8].play();
//				ss.addNote(8);
//			}
//		}
//		else if (x<387)	{
//			curFloor=354;
//			curCeiling=387;
//			if ((y<202) && (y>0))	{
//				acArray[9].play();
//				ss.addNote(9);
//			}
//		}
//		else if (x<416)	{
//			curFloor=387;
//			curCeiling=416;
//			if ((y<197) && (y>0))	{
//				acArray[10].play();
//				ss.addNote(10);
//			}
//		}
//		else if (x<448)	{
//			curFloor=416;
//			curCeiling=448;
//			if ((y<194) && (y>0))	{
//				acArray[11].play();
//				ss.addNote(11);
//			}
//		}
//		else if (x<478)	{
//			curFloor=448;
//			curCeiling=478;
//			if ((y<192) && (y>0))	{
//				acArray[12].play();
//				ss.addNote(12);
//			}
//		}
//		else if (x<508)	{
//			curFloor=478;
//			curCeiling=508;
//			if ((y<189) && (y>25))	{
//				acArray[13].play();
//				ss.addNote(13);
//			}
//		}
//		else if (x<538)	{
//			curFloor=508;
//			curCeiling=538;
//			if ((y<187) && (y>29))	{
//				acArray[14].play();
//				ss.addNote(14);
//			}
//		}
//		else	{
//			curFloor=538;
//			curCeiling=1601;
//		}
//		curImage=mdImage;
//		repaint(mx, my, 37, 290);
//		repaint(0,233, 575, 85);
//	}
//	else	{
//		if ((y>=236) && (y<241))	{
//			ss.addNote(14);
//			acArray[14].play();
//		}
//		else if (y<246)	{
//			ss.addNote(13);
//			acArray[13].play();
//		}
//		else if (y<251)	{
//			ss.addNote(12);
//			acArray[12].play();
//		}
//		else if (y<256)	{
//			ss.addNote(11);
//			acArray[11].play();
//		}
//		else if (y<261)	{
//			ss.addNote(10);
//			acArray[10].play();
//		}
//		else if (y<266)	{
//			ss.addNote(9);
//			acArray[9].play();
//		}
//		else if (y<271)	{
//			ss.addNote(8);
//			acArray[8].play();
//		}
//		else if (y<276)	{
//			ss.addNote(7);
//			acArray[7].play();
//		}
//		else if (y<281)	{
//			ss.addNote(6);
//			acArray[6].play();
//		}
//		else if (y<286)	{
//			ss.addNote(5);
//			acArray[5].play();
//		}
//		else if (y<291)	{
//			ss.addNote(4);
//			acArray[4].play();
//		}
//		else if (y<296)	{
//			ss.addNote(3);
//			acArray[3].play();
//		}
//		else if (y<301)	{
//			ss.addNote(2);
//			acArray[2].play();
//		}
//		else if (y<306)	{
//			ss.addNote(1);
//			acArray[1].play();
//		}
//		else if (y<311)	{
//			ss.addNote(0);
//			acArray[0].play();
//		}
//		repaint(0,233, 575, 85);
//	}
//	}
//	public void mouseReleased(MouseEvent e)	{
//		curImage=malletImage;
//		repaint(mx, my, 37, 290);
//	}
 //   public void mouseClicked(MouseEvent e) {
  //  }
   // public void mouseEntered(MouseEvent e) {
    //	int y=e.getY();
	//	if (y>233)	{
	//		if (up)	{
	//			up=false;
	//			setCursor(new Cursor(Cursor.HAND_CURSOR));
	//		}
	//	}
	//	else	{
	//		if (!up)	{
	//			up=true;
	//			setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
	//		}
	//	}
	//	repaint();
  //  }
//
 //   public void mouseExited(MouseEvent e) {
//		repaint();
 //   }
//};
		addMouseListener(ml);
	}
	public void paint(Graphics g)	{
		g.drawImage(xyloImage, 0,0,this);
		g.drawImage(trebleClefImage, 0,250,this);
		g.setColor(Color.black);
		g.drawLine(0,258,575,258);
		g.drawLine(0,268,575,268);
		g.drawLine(0,278,575,278);
		g.drawLine(0,288,575,288);
		g.drawLine(0,298,575,298);
		for(int i=0;i<20;i++)	{
			if (ss.noteList[i]!=0)	{
				g.fillOval(50+25*i, 303-5*(ss.noteList[i]-1)+1, 12, 9);
				if (ss.noteList[i]==1)
					g.drawLine(50+25*i-3,308,50+25*i+15,308);
				else if (ss.noteList[i]>12)	{
					g.drawLine(50+25*i-3,248,50+25*i+15,248);
					if (ss.noteList[i]==15)
						g.drawLine(50+25*i-3,238,50+25*i+15,238);
				}
				if (ss.noteList[i]<7)	{
					g.drawLine(62+25*i, 303-5*(ss.noteList[i]-1)+5, 62+25*i, 303-5*(ss.noteList[i]-1)-28);
					switch (ss.rhythmList[i])	{
						case 2: g.drawImage(eighthImage, 62+25*i, 303-5*(ss.noteList[i]-1)-20, this);
						case 1: g.drawImage(eighthImage, 62+25*i, 303-5*(ss.noteList[i]-1)-28, this);
					}
				}
				else	{
					g.drawLine(50+25*i, 303-5*(ss.noteList[i]-1)+5, 50+25*i, 303-5*(ss.noteList[i]-1)+38);
					switch (ss.rhythmList[i])	{
						case 2: g.drawImage(eighthImage2, 50+25*i-6, 303-5*(ss.noteList[i]-1)+12, this);
						case 1: g.drawImage(eighthImage2, 50+25*i-6, 303-5*(ss.noteList[i]-1)+20, this);
					}
				}
			}
		}
		if (up)	{
			g.drawImage(curImage, mx, my, this);
		}
	}
	public void mouseMoved(MouseEvent e)  {
		int x=e.getX();
		int y=e.getY();
		if (y>233)	{
			if (up)	{
				up=false;
				setCursor(new Cursor(Cursor.HAND_CURSOR));
				repaint();
			}
		}
		else	{
			if (!up)	{
				up=true;
				setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
			}
		}
		int tempY=0;
	    if (y-15-my>0)
		tempY=my;
	    else
		tempY=y-16;
		if (y<233)	{
		    if (x-mx>18)	{
			    repaint(mx, tempY, x-mx+20, 290);
		    }
		    else	{
			    repaint(x-18,tempY,54+mx-x,290);
		    }
		}
	    mx=x-18;
	    my=y-15;
	}
	public void mouseDragged(MouseEvent e)  {
		int x=e.getX();
		int y=e.getY();
		if (y>233)	{
			if (up)	{
				up=false;
				setCursor(new Cursor(Cursor.HAND_CURSOR));
				repaint();
			}
		}
		else	{
			if (!up)	{
				up=true;
				setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
			}
		}
		int tempY=0;
	    if (y-15-my>0)
			tempY=my;
	    else
			tempY=y-16;
		if (y<233)	{
		    if (x-mx>18)	{
			    repaint(mx, tempY, x-mx+20, 290);
	    	}
		    else	{
			    repaint(x-18,tempY,54+mx-x,290);
	    	}
	    }
	    mx=x-18;
	    my=y-15;
	    if (((e.getX()>curCeiling)||(e.getX()<curFloor))&&(e.getY()<233))
	    	ml.mousePressed(e);
	}
	public void destroy()	{
		removeMouseMotionListener(this);
	}
	public boolean action(Event e, Object arg)	{
		if (e.target instanceof Button)	{
			if (((Button)e.target).equals(playButton))	{
				if (playButton.getLabel().equals(new String("Play")))	{
					playButton.setLabel("Pause");
					ss.play();
				}
				else	{
					ss.pause();
				}
			}
			else if (((Button)e.target).equals(stopButton))	{
				ss.stop();
			}
			else if (((Button)e.target).equals(deleteButton))	{
				ss.stop();
				ss.erase();
				repaint(0,233,600,150);
			}
			else if (((Button)e.target).equals(deleteLastButton))	{
				ss.stop();
				ss.eraseLast();
				repaint(0,233,600,150);
			}
		}
		return super.action(e, arg);
	}
}
public class SongSaver	{
	int[] noteList, rhythmList;
	int currentSlot;
	static int currentPlayingNote;
	static boolean paused;
	static boolean stopped;
	SongSaver()	{
		noteList=new int[20];
		rhythmList=new int[20];
		currentSlot=0;
		paused=false;
		currentPlayingNote=0;
	}
	public void play()	{
		paused=false;
		new PlayThread(this).start();
	}
	public void pause()	{
		paused=true;
	}
	public void stop()	{
		stopped=true;
		paused=true;
	}
	public void addNote(int n)	{
		if (noteList[19]==0)	{
			noteList[currentSlot]=n+1;
			rhythmList[currentSlot]=Xylophone.rhythmChoice.getSelectedIndex();
			currentSlot++;
		}
	}
	public void erase()	{
		noteList=new int[20];
		currentSlot=0;
	}
	public void eraseLast()	{
		currentSlot--;
		int i;
		for (i=-1;i<19;i++)	{
			if (noteList[i+1]==0)	{
				noteList[i]=0;
				i=20;
			}
		}
		if (i==19)	{
			noteList[19]=0;
		}
	}
}
public class PlayThread extends Thread	{
	int[] noteList, rhythmList;
	int currentSlot;
	int currentPlayingNote;
	PlayThread(SongSaver ss)	{
		this.noteList=ss.noteList;
		this.rhythmList=ss.rhythmList;
		this.currentPlayingNote=ss.currentPlayingNote;
	}
	public void run()	{
			int s;
			for (int i=this.currentPlayingNote;(i<20)&&(noteList[i]!=0);i++)	{
				Xylophone.acArray[noteList[i]-1].play();
				s=rhythmList[i];
				if (s==0)
					s=100*(Xylophone.tempoChoice.getSelectedIndex()*2+6)-80;
				else if (s==1)
					s=50*(Xylophone.tempoChoice.getSelectedIndex()*2+6)-80;
				else
					s=25*(Xylophone.tempoChoice.getSelectedIndex()*2+6)-80;
				try	{
					Thread.sleep(s);
				} catch(Exception e)	{}
				if (SongSaver.paused)	{
					currentPlayingNote=i;
					i=20;
				}
			}
		if (SongSaver.stopped)	{
			SongSaver.currentPlayingNote=0;
			SongSaver.stopped=false;
		}
		else
			SongSaver.currentPlayingNote=this.currentPlayingNote+1;
		Xylophone.playButton.setLabel("Play");
		if (!SongSaver.paused)
			SongSaver.currentPlayingNote=0;
	}
}
public class XyloListener implements MouseListener	{
	Xylophone xylo;
	XyloListener(Xylophone xylo)	{
		super();
		this.xylo=xylo;
	}
	public void mousePressed(MouseEvent e)	{
		int x=e.getX();
		int y=e.getY();
	if (y<233)	{
		if (x<60)	{
			Xylophone.curFloor=-1;	//negative denotes N/A
			Xylophone.curCeiling=60;
		}
		else if (x<93)	{
			Xylophone.curFloor=60;
			Xylophone.curCeiling=93;
			if ((y<233) && (y>0))	{
				Xylophone.acArray[0].play();
				Xylophone.ss.addNote(0);
			}
		}
		else if (x<125)	{
			Xylophone.curFloor=93;
			Xylophone.curCeiling=125;
			if ((y<233) && (y>0))	{
				Xylophone.acArray[1].play();
				Xylophone.ss.addNote(1);
			}
		}
		else if (x<158)	{
			Xylophone.curFloor=125;
			Xylophone.curCeiling=158;
			if ((y<223) && (y>0))	{
				Xylophone.acArray[2].play();
				Xylophone.ss.addNote(2);
			}
		}
		else if (x<191)	{
			Xylophone.curFloor=158;
			Xylophone.curCeiling=191;
			if ((y<220) && (y>0))	{
				Xylophone.acArray[3].play();
				Xylophone.ss.addNote(3);
			}
		}
		else if (x<223)	{
			Xylophone.curFloor=191;
			Xylophone.curCeiling=223;
			if ((y<218) && (y>0))	{
				Xylophone.acArray[4].play();
				Xylophone.ss.addNote(4);
			}
		}
		else if (x<257)	{
			Xylophone.curFloor=223;
			Xylophone.curCeiling=257;
			if ((y<215) && (y>0))	{
				Xylophone.acArray[5].play();
				Xylophone.ss.addNote(5);
			}
		}
		else if (x<289)	{
			Xylophone.curFloor=257;
			Xylophone.curCeiling=289;
			if ((y<210) && (y>0))	{
				Xylophone.acArray[6].play();
				Xylophone.ss.addNote(6);
			}
		}
		else if (x<322)	{
			Xylophone.curFloor=289;
			Xylophone.curCeiling=322;
			if ((y<207) && (y>0))	{
				Xylophone.acArray[7].play();
				Xylophone.ss.addNote(7);
			}
		}
		else if (x<354)	{
			Xylophone.curFloor=322;
			Xylophone.curCeiling=354;
			if ((y<206) && (y>0))	{
				Xylophone.acArray[8].play();
				Xylophone.ss.addNote(8);
			}
		}
		else if (x<387)	{
			Xylophone.curFloor=354;
			Xylophone.curCeiling=387;
			if ((y<202) && (y>0))	{
				Xylophone.acArray[9].play();
				Xylophone.ss.addNote(9);
			}
		}
		else if (x<416)	{
			Xylophone.curFloor=387;
			Xylophone.curCeiling=416;
			if ((y<197) && (y>0))	{
				Xylophone.acArray[10].play();
				Xylophone.ss.addNote(10);
			}
		}
		else if (x<448)	{
			Xylophone.curFloor=416;
			Xylophone.curCeiling=448;
			if ((y<194) && (y>0))	{
				Xylophone.acArray[11].play();
				Xylophone.ss.addNote(11);
			}
		}
		else if (x<478)	{
			Xylophone.curFloor=448;
			Xylophone.curCeiling=478;
			if ((y<192) && (y>0))	{
				Xylophone.acArray[12].play();
				Xylophone.ss.addNote(12);
			}
		}
		else if (x<508)	{
			Xylophone.curFloor=478;
			Xylophone.curCeiling=508;
			if ((y<189) && (y>25))	{
				Xylophone.acArray[13].play();
				Xylophone.ss.addNote(13);
			}
		}
		else if (x<538)	{
			Xylophone.curFloor=508;
			Xylophone.curCeiling=538;
			if ((y<187) && (y>29))	{
				Xylophone.acArray[14].play();
				Xylophone.ss.addNote(14);
			}
		}
		else	{
			Xylophone.curFloor=538;
			Xylophone.curCeiling=1601;
		}
		Xylophone.curImage=Xylophone.mdImage;
		xylo.repaint(Xylophone.mx, Xylophone.my, 37, 290);
		xylo.repaint(0,233, 575, 85);
	}
	else	{
		if (y<236)
			;
		else if (y<241)	{
			Xylophone.ss.addNote(14);
			Xylophone.acArray[14].play();
		}
		else if (y<246)	{
			Xylophone.ss.addNote(13);
			Xylophone.acArray[13].play();
		}
		else if (y<251)	{
			Xylophone.ss.addNote(12);
			Xylophone.acArray[12].play();
		}
		else if (y<256)	{
			Xylophone.ss.addNote(11);
			Xylophone.acArray[11].play();
		}
		else if (y<261)	{
			Xylophone.ss.addNote(10);
			Xylophone.acArray[10].play();
		}
		else if (y<266)	{
			Xylophone.ss.addNote(9);
			Xylophone.acArray[9].play();
		}
		else if (y<271)	{
			Xylophone.ss.addNote(8);
			Xylophone.acArray[8].play();
		}
		else if (y<276)	{
			Xylophone.ss.addNote(7);
			Xylophone.acArray[7].play();
		}
		else if (y<281)	{
			Xylophone.ss.addNote(6);
			Xylophone.acArray[6].play();
		}
		else if (y<286)	{
			Xylophone.ss.addNote(5);
			Xylophone.acArray[5].play();
		}
		else if (y<291)	{
			Xylophone.ss.addNote(4);
			Xylophone.acArray[4].play();
		}
		else if (y<296)	{
			Xylophone.ss.addNote(3);
			Xylophone.acArray[3].play();
		}
		else if (y<301)	{
			Xylophone.ss.addNote(2);
			Xylophone.acArray[2].play();
		}
		else if (y<306)	{
			Xylophone.ss.addNote(1);
			Xylophone.acArray[1].play();
		}
		else if (y<311)	{
			Xylophone.ss.addNote(0);
			Xylophone.acArray[0].play();
		}
		xylo.repaint(0,233, 575, 85);
	}
	}
	public void mouseReleased(MouseEvent e)	{
		Xylophone.curImage=Xylophone.malletImage;
		xylo.repaint(Xylophone.mx, Xylophone.my, 37, 290);
	}
    public void mouseClicked(MouseEvent e) {
    }
    public void mouseEntered(MouseEvent e) {
    	int y=e.getY();
		if (y>233)	{
			if (Xylophone.up)	{
				Xylophone.up=false;
				xylo.setCursor(new Cursor(Cursor.HAND_CURSOR));
			}
		}
		else	{
			if (!Xylophone.up)	{
				Xylophone.up=true;
				xylo.setCursor(new Cursor(Cursor.CROSSHAIR_CURSOR));
			}
		}
		xylo.repaint();
    }

    public void mouseExited(MouseEvent e) {
		xylo.repaint();
    }
}