import java.awt.*;
import java.net.*;
import java.util.*;

/*
* A class that represents a paragraph of text as an array of strings.
* It takes a string as one of the arguments in the constructor, and
* 'wraps' it, creating an array of strings the appropriate length.
* It stores ,as fields, the string array, its x and y start location,
* its width, its color and rollover color, the url it will link to,
* its fontMetrics, leading, and number of lines. It provides a method
* for checking if the mouse is within the paragraph bounds.
* -a.c
*/

class TextLink
{
	private static final int MAX_STRINGS = 20;

	public TextLink(String s, String u, String t, int x, int y, int bw, int ld, Color c, Color rc, FontMetrics fm)
    {
		sCount = 0;
		stringArray = new String[MAX_STRINGS];
		textColor = c;
		rollColor = rc;
		leading = ld;

		wrapString(s, fm, bw);

		fontHeight = fm.getHeight();
		blockStart = new Point(x, y);
		blockEnd = new Point(bw + x, ((getNumStrings()-1) * leading) + y);
		rolledOver = false;

		target = t;

		try
		{
			urlLink = new URL (u);
		}
		catch (MalformedURLException e)
		{
			System.out.println("URL Error: " + e);
		}
    }

	public boolean mouseWithin(int x, int y)
	{
		if ( (x >= blockStart.x ) && (y >= blockStart.y - fontHeight) && (x <= blockEnd.x) && (y <= blockEnd.y) )
			return true;
		else
			return false;
	}

	public String getString(int x)
	{
		try
		{
			if (stringArray[x] != null)
				return stringArray[x];
			else
				return "";
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			return "";
		}
	}

	public int getLeading(int i) {
		return blockStart.y + (leading * i);
	}

	public Point getPos() {
		return blockStart;
	}

	public int getNumStrings() {
		return sCount + 1;
	}

	public Color getTextColor() {
		if (!rolledOver)
			return textColor;
		else
			return rollColor;
	}

	public void setTextColor(Color c) {
		textColor = c;
	}

	public boolean fadeTo (Color fc, int fadeSpeed) {

		int r = textColor.getRed();
		int g = textColor.getGreen();
		int b = textColor.getBlue();
		boolean rState, gState, bState;

		if (!( (r >= fc.getRed()-fadeSpeed) && (r <= fc.getRed()+fadeSpeed) ) ){
			r = (r < fc.getRed()) ? r+fadeSpeed : r-fadeSpeed;
			rState = false;
		} else
			rState = true;

		if (!( (g >= fc.getGreen()-fadeSpeed) && (g <= fc.getGreen()+fadeSpeed) ) ){
			g = (g < fc.getGreen()) ? g+fadeSpeed : g-fadeSpeed;
			gState = false;
		} else
			gState = true;

		if (!( (b >= fc.getBlue()-fadeSpeed) && (b <= fc.getBlue()+fadeSpeed) ) ){
			b = (b < fc.getBlue()) ? b+fadeSpeed : b-fadeSpeed;
			bState = false;
		} else
			bState = true;

		textColor = new Color(r,g,b);

		if (rState && gState && bState){
			textColor = fc;
			return true;
		} else
			return false;
	}

	public URL getUrl() {
		return urlLink;
	}

	public String getTarget() {
		return target;
	}

	public void setHighlight(boolean state) {
		rolledOver = state;
	}

	public boolean getHighlight() {
		return rolledOver;
	}

	private void wrapString(String str, FontMetrics fm, int blockWidth) {
		String nextWord = "";
		String tempString = "";
		StringTokenizer t = new StringTokenizer(str);
		boolean EOL = false;

		while ( t.hasMoreTokens() )  {
			if (!EOL) nextWord = t.nextToken();

			if ( (fm.stringWidth(tempString) + fm.stringWidth(nextWord) >= blockWidth) && (t.countTokens() == 0) ) {
				stringArray[sCount] = tempString;
				stringArray[++sCount] = nextWord;
				return;
			}
			else if ( fm.stringWidth(tempString) + fm.stringWidth(nextWord) >= blockWidth ) {
				EOL = true;
				stringArray[sCount++] = tempString;
				tempString = "";
			}
			else if ( t.countTokens() == 0 ) {
				stringArray[sCount] = tempString + nextWord;
				return;
			}
			else {
				EOL = false;
				tempString += nextWord + " ";
			}
		}
	}

	private URL urlLink;
	private String target;
	private Point blockStart;
	private Point blockEnd;
	private int leading;
	private int fontHeight;
	private Color textColor;
	private Color rollColor;
	private	int sCount;
	private String[] stringArray;
	private boolean rolledOver;
}
