// Stardust 2.0 by von Kotow (http://piter.on.to, piter2003@mail.ru)
import java.util.Vector;
import java.awt.*;
import java.net.*;
import java.io.*;

public class Stardust extends java.applet.Applet implements Runnable {
	int Width, Height, Xmax, Ymax;
	Thread me = null;
	boolean suspend = false;
	Image im;
	private Image backdrop;
	private int m_Height;
	private int m_Hei = 240;
	private int m_Hey = 1;
	private int m_Hez = 0;
	private int m_Width = 320;
	private int m_CurrLine = 0;
	private int m_NumLines;
	private int m_Decrement = 1;
	private int m_Longitude = 0;
	private String m_string = "This applet contains multi-line strings |" +
		"You can specify them in parameter \"string\" with delimeter Alt-124 |" +
		"You can change the parameter \"Number_of_stars\" |" +
		"Set parameter \"direction\" to \"up\" or \"center\" |" +
		"Set parameter \"font\" to desired font face |" +
		"Set parameter \"size\" for font size |" +
		"Set parameter \"color\" for font color |" +
		"Set parameter \"style\" to \"plain\", \"bold\" or \"italic\" |" +
		"Set parameter \"fps\" to desired speed (frames per second) |" +
		"Set parameter \"URL\" to enable visitor move by click to another page |" +
		"Click here to visit author's homepage |" +
		"Now roll over again.";
	private String m_URL = "||||||||||http://www.geocities.com/von_kotow/";
	private String m_face = "Tahoma";
	private Font m_font;
	private String m_style = "PLAIN";
	private String m_dir = "center";
	private int m_size = 14;
	private int m_style1;
	private int m_fps = 20;
	private int m_Sleep;
	private int m_b = 0;
	private String m_color;
	private String text[];
	Graphics offscreen;
	int N_Stars;
	int mx, my, dx, dy, mxold, myold; //m: mouse pixel from center
	double  crot, srot, rot;
	Dimension m_dimImage;
	Fly_by_Star FStar[]; //Fly-by Star
  	Background_Star BStar[]; //Background
	private final String PARAM_string = "string";
	private final String PARAM_font = "font";
	private final String PARAM_style = "style";
	private final String PARAM_size = "size";
	private final String PARAM_fps = "fps";
	private final String PARAM_URL = "URL";
	private final String PARAM_color = "color";
	private String urls[];
	private Color colours[];
	private Vector data;
	private URL targetURL=null;
    private Image[] slogan;
	private String[][] m_Ma;
	private int[] m_howMany;
	private Graphics m_bg;
	private FontMetrics fm;

	public String[][] getParameterInfo()
	{	String[][] info =
		{	{ PARAM_string, "String", "String to output in marquee" },
			{ PARAM_font, "String", "Font to use" },
			{ PARAM_style, "String", "PLAIN, BOLD or ITALIC" },
			{ PARAM_size, "int", "Font size [pts]" },
			{ PARAM_fps, "int", "Frame rate" },
			{ PARAM_URL, "String", "Destination URL" },
			{ PARAM_color, "String", "Color of the string" },
		};
		return info;		
	}

	public void init() {
		int leftMargin=0, centreMargin=0, rightMargin=0;

		showStatus( "Retrieving data ..." );
		Width = size().width;
		Height = size().height;
		String  Number_of_Stars = getParameter( "Number_of_Stars" );
		N_Stars = ( Number_of_Stars == null ) ? 20 : Integer.valueOf( Number_of_Stars ).intValue();
		BStar = new Background_Star[N_Stars];
		FStar = new Fly_by_Star[N_Stars];
		for( int i = 0; i < N_Stars; i++ ) {
			BStar[i] = new Background_Star( Width, Height );
			FStar[i] = new Fly_by_Star( Width, Height );
		}
		mxold = 0;
		myold = 0;
		Xmax = Width / 2;
		Ymax = Height / 2;
		String param;
		param = getParameter( PARAM_string );
		if( param != null ) m_string = param;
		param = getParameter( PARAM_font );
		if( param != null ) m_face = param;
		param = getParameter( PARAM_style );
		if( param != null ) m_style = param;
		param = getParameter( PARAM_size );
		if( param != null ) m_size = Integer.parseInt( param );
		param = getParameter( PARAM_fps);
		if( param != null ) m_fps = Integer.parseInt( param );
		param = getParameter( PARAM_URL );
		if( param != null ) m_URL = param;
		param = getParameter( "direction" );
		if( param != null ) m_dir = param;
		m_style1 = Font.PLAIN;
		if( m_style.equalsIgnoreCase( "BOLD" ) ) m_style1 = Font.BOLD;
		if( m_style.equalsIgnoreCase( "ITALIC" ) ) m_style1 = Font.ITALIC;
		m_font = new Font( m_face, m_style1, m_size);
		setFont( m_font );
		param = getParameter( PARAM_color );
		if( param != null ) m_color = param;
		m_Sleep = 1000 / m_fps;
		m_dimImage = size();
		m_Height = m_Hei = m_dimImage.height;
		m_Width = m_dimImage.width;
		/* We must center the text.  We will do this in 3 steps:
		1. Find the length of the text.
		2. Calculate what x value to start drawing the text at.
		3. Draw the text. */
		String line = null; data = new Vector(); int index;
		int i; int j = 0; int k = 0;
		for( i = 0; i < m_string.length(); i++ ) {
			if (m_string.charAt(i) == '|') {
				line = m_string.substring( j, i );
				if (line != null) data.addElement( line );
				j = i + 1;
			}
		}
		line = m_string.substring( j, i );
		if (line != null) data.addElement( line );
		m_NumLines = data.size(); 
		text = new String[m_NumLines];
		m_howMany=new int[m_NumLines];
		slogan = new Image[data.size()];
		int ivedmax=0;
		FontMetrics fm = getFontMetrics( m_font ); //FontMetrics fm = this.getToolkit ().getFontMetrics (this.m_font);
		//let's count what's the dimension of dynamic array
		for( i = 0 ; i < data.size() ; i++ ) {
			text[i] = new String( ( String ) data.elementAt( i ) );
			if( text[i].startsWith( "//" ) )
				slogan[i]=getImage(getCodeBase(),text[i].substring( 2, text[i].length() ) );
			Vector ved = new Vector ();
			line = text[i];	String tl;
			leftMargin = 0; centreMargin=0; rightMargin = 0; k = 0;
			for( j = 0; j < line.length(); j++ ) {
				if( ( line.charAt(j) == ' ' ) && ( fm.stringWidth( line.substring( leftMargin, j ) ) > ( m_Width - 20 ) ) ) {
					if( centreMargin==0 ) centreMargin = j;
					tl = line.substring( leftMargin, centreMargin );
					if( tl.length()>0 ) ved.addElement( tl );
					leftMargin = centreMargin;
				}
				if ( line.charAt( j ) == ' ') centreMargin = j;
			}
			if(j > leftMargin) {
				ved.addElement( line.substring( leftMargin, j ) );
			}
			if( ivedmax<ved.size() ) ivedmax=ved.size();
			m_howMany[i]=ved.size();
		}
		//allocate it, then place the divided lines in it
		m_Ma = new String[m_NumLines][ivedmax];
		for( i=0; i < data.size(); i++ ) {
			Vector ved = new Vector();
			line = text[i];	String tl;
			leftMargin=0; centreMargin=0; rightMargin = 0; k=0;
			for( j = 0; j < line.length(); j++ ) {
				if(( line.charAt( j ) == ' ' ) && 
					( fm.stringWidth( line.substring( leftMargin, j ) ) > ( m_Width - 20 ) ) ) {
					if( centreMargin==0 ) centreMargin=j;
					tl = line.substring( leftMargin, centreMargin );
					if( tl.length() > 0 ) {
						m_Ma[i][k] = tl;
						k++;
					}
					leftMargin = centreMargin;
				}
				if( line.charAt( j ) == ' ' ) centreMargin = j;
			}
			if( j>leftMargin ) m_Ma[i][k] = line.substring( leftMargin, j );
			if( text[i].startsWith( "//" ) && slogan[i] == null )
				m_Ma[i][0] = "Image not found: " + text[i].substring( 2, text[i].length() );
		}
		//urls
		urls = new String[m_NumLines]; line = new String();
		leftMargin = 0; k = 0;
		for( i = 0; i < m_NumLines; i++ ) urls[i] = null;
		for( i = 0; i < m_URL.length(); i++) {
			if(m_URL.charAt(i) == '|') {
				line = new String( m_URL.substring( leftMargin, i) );
				if( line.length() > 0 ) urls[k] = line;
				leftMargin = i + 1; k++;
			}
		}
		if(i>( leftMargin+1 ) ) {
			line = new String( m_URL.substring( leftMargin, i) );
			urls[k] = line;
		}
		//colors
		colours = new Color[m_NumLines]; k = 0; line = null;
		colours[0] = Color.blue;
		for( i = 1; i < m_NumLines; i++ ) colours[i] = Color.black;
		i = 0, j = 0;
		if( m_color != null ) {
			for( i = 0, j =0; i < m_color.length(); i++ ) {
				if( m_color.charAt( i ) == '|' ) {
					line = m_color.substring( j, i );
					if( line != null) colours[k] = setColour( line );
					j = i + 1; k++;
				}
			}
		}
		if(( j != ( i+1 )) && ( i != 0 )) {
			line = m_color.substring( j, i );
			colours[k] = setColour( line );
		}
		for( i = 1; i < m_NumLines; i++ )
			if( colours[i] == Color.black ) colours[i]=colours[0];
		try {
			im = createImage( Width, Height );
			offscreen = im.getGraphics();
			backdrop = createImage(Width-20,Height-20);
		}
		catch( Exception e ) {
			offscreen = null;
		}
		Graphics m_bg = backdrop.getGraphics();
}
	
	public Color setColour( String line ) {
		if( line == null ) return Color.blue;
		if( line.equalsIgnoreCase( "cyan" ) ) return Color.cyan;
		if( line.equalsIgnoreCase( "darkGray" ) ) return Color.darkGray;
		if( line.equalsIgnoreCase( "gray" ) ) return Color.gray;
		if( line.equalsIgnoreCase( "green" ) ) return Color.green;
		if( line.equalsIgnoreCase( "lightGray" ) ) return Color.lightGray;
		if( line.equalsIgnoreCase( "magenta" ) ) return Color.magenta;
		if( line.equalsIgnoreCase( "orange" ) ) return Color.orange;
		if( line.equalsIgnoreCase( "pink" ) ) return Color.pink;
		if( line.equalsIgnoreCase( "red") ) return Color.red;
		if( line.equalsIgnoreCase( "white" ) ) return Color.white;
		if( line.equalsIgnoreCase( "yellow" ) ) return Color.yellow;
		return Color.blue;
	}

	public void paint( Graphics g ) {
		if( offscreen != null ) {
			paintMe( offscreen );
			g.drawImage( im, 0, 0, this );
		} else {
			paintMe( g );
		}
	}
	
	public void paintMe( Graphics g ) {
		int i =	0; int j = 0; int length = 0; int start = 0;
		int height = 0;
		FontMetrics fm = getFontMetrics( m_font );
		g.setColor( Color.black );
		g.fillRect( 0, 0, Width, Height );
		if( m_dir.equalsIgnoreCase( "CENTER" ) ) {
			if( slogan[m_CurrLine] == null ) //place letters before stars
			center( g );
		}
		for( i = 0; i < N_Stars; i++ ) {
			BStar[i].BDraw( g, mx, my, dx, dy, crot, srot );        
			FStar[i].Draw( g, mx, my, dx, dy, crot, srot );
		}
		if( m_dir.equalsIgnoreCase( "CENTER" ) ) {
			if( slogan[m_CurrLine] != null ) //place image behind stars
			center( g );
		}
		if( m_dir.equalsIgnoreCase( "UP" ) ) {
			i = 0; j = 0; length = 0; start = 0;
			g.setColor( colours[m_CurrLine] );
			if(slogan[m_CurrLine] != null) {
				start = ( m_Width - slogan[m_CurrLine].getWidth( this ) ) / 2;
				start = ( start < 0) ? 0 : start;
				g.drawImage( slogan[m_CurrLine], start, m_Hei, this );
				m_Hei--;
				if( ( m_Hei + slogan[m_CurrLine].getHeight( this ) ) < 0) {
					m_Hei = m_Height; m_CurrLine++;
					if( m_CurrLine == m_NumLines ) m_CurrLine = 0;
				}
			}
			else {
				for( i = 0 ; i < m_howMany[m_CurrLine]; i++ ) {
					length = fm.stringWidth( m_Ma[m_CurrLine][i] );
					start = ( m_Width / 2 ) - ( length / 2 );
					start = ( start < 0 ) ? 0 : start;
					g.drawString( m_Ma[m_CurrLine][i], start, m_Hei + ( i * 20 ) );
				}
				m_Hei--;
				if(( m_Hei + ( i * 20 )) < 0 ) {
					m_Hei = m_Height; m_CurrLine++;
					if( m_CurrLine == m_NumLines ) m_CurrLine = 0;
				}
			}
		}
	}

	public void center( Graphics g ) {
		int i =	0; int j = 0; int length = 0; int start = 0;
		int height = 0;
		FontMetrics fm = getFontMetrics( m_font );
		Graphics bg = backdrop.getGraphics();
		bg.setColor( Color.black );
		bg.fillRect( 0, 0, Width - 20, Height - 20 );
		int iMaxlen = 0;
		for( i = 0 ; i < m_howMany[m_CurrLine]; i++ ) {
			length = fm.stringWidth (m_Ma[m_CurrLine][i] );
			height = fm.getHeight()+10;
			if( iMaxlen < length ) iMaxlen = length;
			start = ( ( m_Width-20 ) / 2 ) - ( length / 2 );
			start = ( start < 0 ) ? 0 : start;
			bg.setColor( colours[m_CurrLine] );
			bg.drawString( m_Ma[m_CurrLine][i],start, ( Height - (( m_howMany[m_CurrLine] - i ) * height ) ) / 2 );
		}
		int iw1 = m_Width * m_Hey / m_Height;
		int ix1 = ( m_Width - iw1 ) / 2;
		int iy1 = ( m_Height-m_Hey ) / 2 + fm.getHeight();
		if( slogan[m_CurrLine] != null ) {
			iy1 = ( m_Height-m_Hey ) / 2 - m_Hez;
			g.drawImage( slogan[m_CurrLine],ix1,iy1,iw1,m_Hey,this );
		} else
			g.drawImage( backdrop,ix1,iy1,iw1,m_Hey,this );
		if( m_Decrement == 1 ) m_Hey += 2;
		if( m_Decrement == 2 ) {
			m_Longitude++;
			if( m_Longitude>70) m_Decrement = 3;
		}
		if( m_Decrement == 3 ) m_Hey--;
		if( m_Decrement == 4 ) {
			if(slogan[m_CurrLine] != null) {
				m_Hez += 10;
				if( ( m_Hey+m_Hez ) > m_Height ) {
					m_Hez = 0; m_Hey =1;
					m_Decrement = 1; m_CurrLine++;
					if( m_CurrLine == m_NumLines ) m_CurrLine = 0;
				}
			} else m_Hey += 80;
		}
		if( ( ( m_Hey ) > m_Height ) && ( m_Decrement==1 ) ) {
			m_Decrement = 2; m_Longitude = 0;
		}
		if( ( (m_Hey+20)<m_Height) && ( m_Decrement==3 ) ) {
			m_Decrement=4;
		}
		if( (m_Hey-5000) > m_Height ) {
			m_CurrLine++;
			if( m_CurrLine == m_NumLines ) m_CurrLine = 0;
			m_Hey = 1; m_Decrement = 1;
		}
	}

	public void start() {
		if( me == null ) {
			me = new Thread( this );
			me.start();
		}
	}

	public void stop() {
		if( me != null ) {
			me.stop();
			me = null;
		}
	}

	public void run() {
		while( me != null ) {
			dx = mx - mxold;
			dy = my - myold;
			mxold = mx;
            myold = my;
			rot = 2 * 3.14 / 12 * ( double ) mx / Xmax * 0;
			crot = Math.cos( rot );   
			srot = Math.sin( rot );
			try { Thread.sleep( m_Sleep ); }
			catch ( InterruptedException e ) { }
			repaint();
		}
	}

	public void update( Graphics g ) {
		paint( g );
	}

	public boolean mouseMove( java.awt.Event evt, int x, int y ) {
		mx = x-Xmax;
    	my = y-Ymax;
		return true;
	}

	public boolean mouseEnter( Event e, int x, int y )
	{	
		if( urls[m_CurrLine].length() == 0) {
			showStatus( "Welcome to Von Kotow ");
		} else showStatus( urls[m_CurrLine] );
		return true;
	}
	
	public boolean mouseExit( Event e, int x, int y )
	{ 
		this.showStatus( "Done" ); return true;
	}
	
	public boolean mouseDown( Event me, int x, int y )
	{	
		if( urls[m_CurrLine].length() != 0 ) try
		{	targetURL = ( new URL( urls[m_CurrLine] ) );
			getAppletContext ().showDocument( targetURL );
		} catch( MalformedURLException mue )
		{ showStatus( "Bad URL: " + urls[m_CurrLine] );
	    }
		return true;
	}

	public void Toggle( ) {
		if( me != null ) {
			if( suspend ) {
				me.resume();
			} else {
				me.suspend();
			}
			suspend = !suspend;
		}
	}

	public Stardust() {
	}

	public String getAppletInfo()
	{	return "Name: Stardust\r\n" + "Author: Von Kotow\r\n" +
		       "Created with Microsoft Visual J++ Version 1.0";
	}

}

class Fly_by_Star { 
	int Xmax, Ymax, z;
	double x, y;
	
	Fly_by_Star( int width, int height ) {
		Xmax = width/2;
		Ymax = height/2;
		x = ( Math.random()*width) - Xmax;
		y = ( Math.random()*height) - Ymax;
		if( ( x == 0) && (y == 0 ) ) x = 10;
		z = ( int ) ( Math.random() * 100 );
	} 

	public void Draw( Graphics g, int mx, int my, int dx, int dy, double crot, double srot ) {
		double X, Y;
		int h, v;
		int d;

		z-=2;
		x = x - ( ( double ) mx * crot / 25 - ( double ) my * srot / 25 ) * ( z + 62 ) / 162;
		y = y + ( ( double ) mx * srot / 25 - ( double ) my * crot / 25 ) * ( z + 62 ) / 162;
		if( x < - Xmax ) x += 2 * Xmax;
		if( x > Xmax )x -= 2 * Xmax;
		if( y < -Ymax ) y += 2 * Ymax;
		if( y > Ymax ) y-= 2 * Ymax;
		X = ( x * 164 / ( 64 + z ) );
		Y = ( y * 164 / ( 64 + z) );
		if( ( X < -Xmax) || ( X > Xmax ) ) z = 100;
		if( ( Y < -Ymax) || ( Y > Xmax ) ) z = 100;
		h = (int)( X * crot - Y * srot ) + Xmax;
		v = (int)( X * srot + Y * crot) + Ymax;
		if ( z > 50 )g.setColor( Color.gray );
		else if( z > 25 ) g.setColor( Color.lightGray );
		else g.setColor( Color.white );
		d = ( 100 - z ) / 40;
		if( d == 0 ) d = 1;
		if( d == 1 ) g.setColor( Color.white );
		g.fillRect( h, v, d, d );
	} 
}

class Background_Star {	
	int      Xmax, Ymax, z;
	double x, y;

	Background_Star( int width, int height ) {
		Xmax = width / 2;
		Ymax = height / 2;
		x = ( Math.random() * width ) - Xmax;
		y = ( Math.random() * height ) - Ymax;
		if( ( x == 0 ) && ( y == 0 ) ) x = 10;
		z = (int)( Math.random() * 100); // Here it means brightness
	}

	public void BDraw( Graphics g, int mx, int my, int dx, int dy, double crot, double srot) {
		int h, v;
		int d;

		x = x - ( double ) mx * crot / 25 - ( double ) my * srot / 25;
		y = y + (double)mx*srot/25 - ( double ) my * crot / 25;
		if( x < -Xmax ) x += 2 * Xmax;
		if( x > Xmax ) x -= 2 * Xmax;
		if( y < -Ymax ) y += 2 * Ymax;
		if( y > Ymax ) y -= 2 * Ymax;
		h = ( int )( x * crot - y * srot) + Xmax;
		v = ( int )( x * srot + y * crot) + Ymax;
		if( h < 0 ) h += 2 * Xmax;
		if( h > 2 * Xmax ) h -= 2 * Xmax;
		if( v < 0 ) v += 2 * Ymax;
		if( v > 2 * Ymax ) v -= 2 * Ymax;
		if( z > 50 ) g.setColor( Color.gray );
		else if( z > 25 ) g.setColor( Color.lightGray );
		else g.setColor( Color.lightGray );
		d = ( 100 - z ) / 50;
		if( d == 0 ) d = 1;
		g.fillRect( h, v, d, d );
	} 
}