/////////////////////////////////////////////
// Autobahner Markup Language              //
// Steve Bobach  stylinsty@yahoo.com       //
// www.streetboards.com/steve/applets      //
/////////////////////////////////////////////

import java.awt.*;
import java.applet.*;
import java.applet.AppletStub;
import java.lang.Thread;
import java.util.StringTokenizer;
import java.util.*;
import java.lang.Math;
import java.awt.image.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.*;



class Actor_Class
{
	int id;
	String type;
	String s0;


	int x;
	int y;
	int xv;
	int yv;

	int wd;
	int ht;

	int i;

	static autobahner p;
	boolean visible;
	boolean active;

	Color c;



	Actor_Class()
	{
		x = 10;
		y = 10;
		xv=0;
		yv=0;
		type = "NULL";
		s0="NULL";
		id = 0;
		off();
	}


	public void reset()
	{
		on();
	}

	public void update()
	{
	}

	public void paint()
	{

	}

	public void on()
	{
		visible=active=true;
	}

	public void off()
	{
		visible=active=false;
	}
	
}


class AString extends Actor_Class
{
	String s;
	int spd;
	public URL theURL;

	int death;

	double r=3; 
	double g=3;
	double b=3;
	double frames; 
	double dir=1;
	double fno=0;



	Color d;

	AString(String _s, String _type, int _id, int _spd)
	{
		super();
		id = _id;
		death =0;
		type = _type;
		c = Color.blue;
		d = Color.black;

		s=_s;
		spd = _spd;
		if (spd==1) frames=125;
		if (spd==2) frames=60;
		if (spd==3) frames=30;
		if (spd==4) frames=15;
		if (spd==5) frames=5;
		
		if (spd==5) spd=10;
		if (spd==4) spd=7;
		if (spd==3) spd=4;
		
		reset();
		off();
	}

	public void update()
	{

		x+=xv;
		y+=yv;
		if (x>p.wd+10) death=1;
		if (x<-10-p.fm.stringWidth(s)) death=1;
		if (y>p.ht+p.fm.getHeight()+10) death=1;
		if (y< (-p.fm.getHeight()-10) ) death=1;
	
		
		if (death==1) 
		{
		off();
			if ( (id+1>=p.actor.length) || (p.actor[id+1].type.equals("NULL")) )
			{
				p.actor[1].reset();
			}
			else
			p.actor[id+1].reset();
		}


	} //  update

	public void paint()
	{

		if (type.equals("FT"))
		{
		r=(((double)c.getRed())/frames)*fno;
		g=(((double)c.getGreen())/frames)*fno;
		b=(((double)c.getBlue())/frames)*fno;

		fno += dir;
		if (fno>frames)
		{
			fno=frames;
			dir = -1;
		}


		if (fno<=1) 
			if (dir==-1)
				death=1;


		d = new Color((int)r,(int)g,(int)b);
		p.dbuff.setColor(d);
		}
		else 	p.dbuff.setColor(c);
		
		p.dbuff.drawString(s,x,y);
		if (!s0.equals("NULL") )
			p.dbuff.drawLine(x,y+2,x+p.fm.stringWidth(s),y+2);
	}


	public void reset()
	{
		on();
		death=0;

		if (type.equals("FT"))	 // Fade Text
		{
			x=(p.wd/2)-(p.fm.stringWidth(s)/2);
			y=p.ht/2+(p.fm.getHeight()/3);
			xv=0;
			yv=0;
			r=g=b=3;
			dir = 1;
		}
		else		
		if (type.equals("RL"))
		{
			x=p.wd;
			y=(p.ht/2)+(p.fm.getHeight()/3);
			xv=-spd;
			yv=0;
		}
		else if (type.equals("LR"))
		{
			x=0-p.fm.stringWidth(s);
			y=p.ht/2+(p.fm.getHeight()/3);
			xv=spd;
			yv=0;
		}
		else if (type.equals("TB"))
		{
			x=(p.wd/2)-(p.fm.stringWidth(s)/2);
			y=0;
			xv=0;
			yv=spd;
		}
		else if (type.equals("BT"))
		{
			x=(p.wd/2)-(p.fm.stringWidth(s)/2);
			y=p.ht+p.fm.getHeight();
			xv=0;
			yv=-spd;
		}
		else
		{
			x=y=0;
			xv=yv=0;
		}


	}
}





class Starmode extends Actor_Class
{
	int m;
	
	Starmode(int _m, int _id)
	{
		m = _m;
		id = _id;
		type="Starmode";
	}

	public void update()
	{
		if (m==6) p.stopthread=true;   // TN
		else
		if (m==7) p.stopthread=false;  // TF
		else
		if (m==8) p.destroyapp=true;	   // DN
		else
		if (m==9) p.destroyapp=false;   // DF
		else
		if (m==4) p.actor[0].on();
		else
		if (m==5) p.actor[0].off();
		else
		if ( (m==10) || (m<4) )
		((Stars)p.actor[0]).movemode = m;  // 10 no stars moving

		if ( (id+1>=p.actor.length) || (p.actor[id+1].type.equals("NULL")) )
			{
				p.actor[1].reset();
			}
		else
			p.actor[id+1].reset();
	
	off();
	}
}
 
class Stars extends Actor_Class
{
	double x[];	 // current x position
	double y[];
	double xv[]; // current x velocity
	double yv[];
	double gx[]; // goal speed for xv
	double gy[];
	Color cl[];

		
	int movemode;

	
	Stars()
	{
	x  = new double[360];
	y  = new double[360];
	xv = new double[360];
	yv = new double[360];
	gx = new double[360];
	gy = new double[360];
	cl = new Color[360];

	int t;
	int f = 255/6;

		for (i=0; i<x.length; i++)
		{
			x[i] = Math.random()*p.wd;
			y[i] = Math.random()*p.ht;
			xv[i] = 0;
			yv[i] = 0;
			gx[i] = Math.random()*3;
			gy[i] = Math.random()*3;
		
			t = Math.abs((int)gx[i])+Math.abs((int)gy[i]);
			cl[i] = new Color(f*t, f*t, f*t);
		}

	on();
	movemode = 2; // up, down, left, right
	type="Stars";
	}


	public void update()
	{

		if (movemode==10)
		{
			for (i=0; i<x.length; i++)
			{
			if (yv[i]>0) yv[i]-=.05;
			if (yv[i]<0) yv[i]+=.05;
			if (xv[i]<0) xv[i]+=.05;
			if (xv[i]>0) xv[i]-=.05;
			if ( (int)xv[i]==0) xv[i]=0;
			if ( (int)yv[i]==0) yv[i]=0;
			}
		}
		  
		if (movemode==0)
		{
			for (i=0; i<x.length; i++)
			{
			if (yv[i]>-gy[i]) yv[i]-=.05;
			if (xv[i]>0) xv[i]-=.05;
			if (xv[i]<0) xv[i]+=.05;
			if ( (int)xv[i]==0) xv[i]=0;
			}
		}

		if (movemode==1)
		{
			for (i=0; i<x.length; i++)
			{
			if (yv[i]<gy[i]) yv[i]+=.05;
			if (xv[i]>0) xv[i]-=.05;
			if (xv[i]<0) xv[i]+=.05;
			if ( (int)xv[i]==0) xv[i]=0;
			}
		}
		
		if (movemode==2)
		{
			for (i=0; i<x.length; i++)
			{
			if (xv[i]>-gx[i]) xv[i]-=.05;
			if (yv[i]>0) yv[i]-=.05;
			if (yv[i]<0) yv[i]+=.05;
			if ( (int)yv[i]==0) yv[i]=0;
			}
		}

		if (movemode==3)
		{
			for (i=0; i<x.length; i++)
			{
			if (xv[i]<gx[i]) xv[i]+=.05;
			if (yv[i]>0) yv[i]-=.05;
			if (yv[i]<0) yv[i]+=.05;
			if ( (int)yv[i]==0) yv[i]=0;
			}			
		}
		
		for (i=0; i<x.length; i++)
		{
			x[i]+=xv[i]; y[i]+=yv[i];

			if (x[i]>p.wd) x[i]=0;
			if (y[i]>p.ht) y[i]=0;
			if (x[i]<0) x[i]=p.wd;
			if (y[i]<0) y[i]=p.ht;
		}
	
	}
	
	
	public void paint()
	{

		for (i=0; i<x.length; i++)
		{
		p.dbuff.setColor(cl[i]);
		p.dbuff.drawRect((int)x[i],(int)y[i],1,1);
		}
	}
}



class Autolink_class extends AString
{
	int tried=0;
	public URL theURL;

	Autolink_class	(String _s, String _type, int _id, int _spd)
	{	super(_s,_type,_id,_spd);
		c = Color.blue;
		reset();
		s0="NULL";
		off();
	}


	public	void chklnk()
		{
			if (!s0.equals("NULL"))
			{
				if  ((tried==0) || ((p.md==true)&&(p.mx>=x)&&(p.mx<=x+p.fm.stringWidth(s))&&(p.my<=y)&&(p.my>=y-p.fm.getHeight())))
				{
						try { theURL = new URL(s0); }
						catch  (MalformedURLException e)  {}  
						if ( theURL != null) 
							{
							p.getAppletContext().showDocument(theURL);
							}
							c=Color.white;
					
						tried=1;
				}
					
			}
		}
}


public class autobahner extends Applet implements Runnable
{
	////////////////////////////
	// Standard system variables
	////////////////////////////
	Random			   rnd;
	Font			   fnt;
	FontMetrics        fm;

	Graphics           dbuff;	 // Graphics Context for the double buffer
	Image              dimage;	 // The double buffer image
	Thread			   runner;

	String param0;
    String p0;
	String p1;

	boolean stopthread = true; // pause on/off the applet when at different url
	boolean destroyapp = false; // destroy on/off when at different url
	
	/////////////////////////////
	// Standard runtime variables (may be set here)
	////////////////////////////
	boolean key[];
	int		 lagtimer = 0;	   // set to 0 upon any mouse input
	boolean	 mouse_enter;  // set to 'true' when mouse enters applet
	boolean  paintok = false;      // computer may update window only while not in Stydraw(Synchronized?)
	boolean      md;           // Mouse down
	boolean      mu;           // Mouse up
	int      mx;           // Mouse x
	int      my;           // Mouse y

	int wd;
	int ht;

	MediaTracker       tracker;  // Use in ini

	Actor_Class actor[];
	Image image[];

	int stagelo[]; // the low array number for the stage
	int stagehi[]; // the hi  array number for the stage
	boolean stageon[];

	
	public void init()
	{
		//tracker   = new MediaTracker(this);
		int i;
		int n=0;
		
		rnd		  = new Random();
		fnt       = new Font("TimesRoman", Font.BOLD, 80);
	
		fm = getFontMetrics(fnt);
	
		dimage    = createImage(size().width,size().height);
		dbuff     = dimage.getGraphics();
		dbuff.setFont(fnt);	
		wd = size().width;
		ht = size().height;

		actor = new Actor_Class[500];   

		stagelo = new int[25];
		stagehi = new int[25];
		stageon = new boolean[25];

		for (i=0; i<stageon.length; i++)
		{
			stageon[i]=false;
		}

		stagelo[0] = 0; 	stagehi[0] = 199;
		stagelo[1] = 200; 	stagehi[1] = 299;

		
  		stageon[0] = true;


		for (i=0; i<actor.length; i++)
		{
			actor[i] = new Actor_Class();
		}


		actor[0].p = this; // set static actor variable

	
		param0 = getParameter("String");
		
		StringTokenizer st = new StringTokenizer(param0);

		String type="RL";

		String ur="http://www.streetboards.com/steve/applets/autobahner/autobahner.html";

		int setur=0;

		actor[n] = new Stars();

		n++;
		
		int spd=1;
		int mn=0;
		int r=0;
		int g=0;
		int b=255;
				
		Color c = Color.blue; 


		while  (st.hasMoreTokens())  
		{
			p0 = new String(st.nextToken("|"));
			p0.trim();
			

			if (p0.equals("UR"))
				{
				ur = st.nextToken();
				}
			else
			if (p0.equals("UN"))
				{
				setur=1;
				}
			if (p0.equals("MN"))
				{
				mn=1;
				}
			else
			if (p0.equals("MF"))
				{
				mn=0;
				}
			else
			if (p0.equals("CL"))
				{
				int r1 = Integer.valueOf(st.nextToken()).intValue();
				int g1 = Integer.valueOf(st.nextToken()).intValue();
				int b1 = Integer.valueOf(st.nextToken()).intValue();

				c = new Color(r1,g1,b1);
				}
			else
			if (p0.equals("S1"))
				{
				spd=1;
				}
			else
			if (p0.equals("S2"))
				{
				spd=2;
				}
			else
			if (p0.equals("S3"))
				{
				spd=3;
				}
			else
			if (p0.equals("S4"))
				{
				spd=4;
				}
			else
			if (p0.equals("S5"))
				{
				spd=5;
				}
			else
			if (p0.equals("TN"))
				{
				actor[n]=new Starmode(6,n);
				n++;
				}
			else
			if (p0.equals("TF"))
				{
				actor[n]=new Starmode(7,n);
				n++;
				}
			else
			if (p0.equals("DN"))
				{
				actor[n]=new Starmode(8,n);
				n++;
				}
			else
			if (p0.equals("DF"))
				{
				actor[n]=new Starmode(9,n);
				n++;
				}
			else
			if (p0.equals("SS"))
				{
				actor[n]=new Starmode(10,n);
				n++;
				}
			else
			if (p0.equals("SN"))
				{
				actor[n]=new Starmode(4,n);
				n++;
				}
			else
			if (p0.equals("SF"))
				{
				actor[n]=new Starmode(5,n);
				n++;
				}
			else
			if (p0.equals("SU"))
				{
				actor[n]=new Starmode(0,n);
				n++;
				}
			else
			if (p0.equals("SD"))
				{
				actor[n]=new Starmode(1,n);
				n++;
				}
			else
			if (p0.equals("SL"))
				{
				actor[n]=new Starmode(2,n);
				n++;
				}
			else
			if (p0.equals("SR"))
				{
				actor[n]=new Starmode(3,n);
				n++;
				}
			else
			if (p0.equals("FT"))
				{
				type = "FT";
				p1 = st.nextToken();
				if ((mn==1) && (setur==1))
					actor[n]=new Autolink_class(p1,type,n,spd);
				else
					actor[n]=new AString(p1,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
			else
			if (p0.equals("RL"))
				{
				type = "RL";
				p1 = st.nextToken();
				if ((mn==1) && (setur==1))
					actor[n]=new Autolink_class(p1,type,n,spd);
				else
					actor[n]=new AString(p1,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
			else
			if (p0.equals("LR"))
				{
				type = "LR";
				p1 = st.nextToken();
				if ((mn==1) && (setur==1))
					actor[n]=new Autolink_class(p1,type,n,spd);
				else 
					actor[n]=new AString(p1,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
			else
			if (p0.equals("TB"))
				{
				type = "TB";
				p1 = st.nextToken();
				if ((mn==1) && (setur==1))
				actor[n]=new Autolink_class(p1,type,n,spd);
				else actor[n]=new AString(p1,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
			else
			if (p0.equals("BT"))
				{
				type = "BT";
				p1 = st.nextToken();
				if ((mn==1) && (setur==1))
				actor[n]=new Autolink_class(p1,type,n,spd);
				else
					actor[n]=new AString(p1,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
			else
				{
				if ((mn==1) && (setur==1))
				actor[n]=new Autolink_class(p0,type,n,spd);
				else
					actor[n]=new AString(p0,type,n,spd);
				actor[n].c = c;
				if (setur==1) actor[n].s0=ur; setur=0;
				n++;
				}
		}

	actor[1].on(); 

	}// End Init()


 	public void update(Graphics g)
	{
		paint(g);
	}

	public void start()
	{
		if (runner == null)
		{
			runner = new Thread(this);
			runner.start();
		}
	}

	public void stop()
	{
		if (stopthread==true)
		{
			if (runner != null)
			{
			runner.stop();
			runner = null;
			}
		}
  }


	public void destroy()
	{
		if (destroyapp==true)
		{
			actor = null;
		}

	}





	public boolean mouseEnter(Event evt, int xx, int yy)
	{
		mouse_enter=true;
		return true;
	}

	public boolean mouseExit(Event evt, int x, int y)
	{
		mouse_enter=false;
		return true;
	}

	public boolean mouseMove(Event evt, int x, int y)
	{
		lagtimer = 0;
		mx = x;
		my = y;
		return true;
	}

	public boolean mouseDrag(Event evt, int x, int y)
	{
		lagtimer = 0;
		md = true;
		mu = false;
		mx = x;
		my = y;
		return true;
	}

	public boolean mouseUp(Event evt, int xx, int yy)
	{
	    lagtimer = 0;
	    mu = true;
	    md = false;
		return true;
	}

	public boolean mouseDown(Event evt, int xx, int yy)
	{
		lagtimer = 0;
	    md = true;
	    mu = false;
        return true;
	}

	public void paint(Graphics g)
	{	  
		if (paintok==true)	g.drawImage(dimage, 0, 0, this);
	}


//////////////////////
// Run Function
//////////////////////
public void run()
{
	int i;
	int j;

	paintok=true;


	while (true)
 	{
		dbuff.setColor(Color.black);
		dbuff.fillRect(0,0,wd,ht);
		
		paintok=false; 


		// make go through the stages

		for (i=0; i<stageon.length; i++)
		{
			if (stageon[i]==true)
				for (j=stagelo[i]; j<=stagehi[i]; j++)
				{
				if (actor[j].active==true) actor[j].update();
				if (actor[j].visible==true) actor[j].paint();
				}
		}

		dbuff.setColor(new Color(mx/2,my,255-mx/2));

		dbuff.setFont(fnt);	

		paintok=true; 
	
		repaint(); 

		try
		    {
              Thread.sleep(20);
          }
          catch(InterruptedException ex) {}
	
	
	}

} // end run function
     


}  // END APPLET SKELETON



