/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Vector;

public class BandCanvas
extends Canvas {
    BandThread bt;
    MediaTracker mt;
    protected Vector vis;
    protected Vector vms;
    protected int wait = 20;
    public Image imgOff;
    public Graphics gOff;
    public Dimension last = this.getSize();
    protected int delay = 3000;
    public ImageMorpher act;
    public int iact;
    public Image imgnext;
    public Graphics gnext;
    public int iimg;
    public int nbimg;
    public boolean stretch = false;

    public void setStretch(boolean bl) {
        this.stretch = bl;
    }

    public boolean getStretch() {
        return this.stretch;
    }

    public void setDelay(int n) {
        this.delay = n < 10 ? 1000 : n;
    }

    public int getDelay() {
        return this.delay;
    }

    public BandCanvas() {
        this.mt = new MediaTracker(this);
        this.vis = new Vector(20);
        this.vms = new Vector(20);
    }

    public void addMorpher(ImageMorpher imageMorpher) {
        this.vms.addElement(imageMorpher);
    }

    public void addImage(Image image) {
        this.vis.addElement(image);
        this.mt.addImage(image, this.nbimg++);
    }

    public void start() {
        try {
            if (this.bt == null) {
                this.bt = new BandThread();
            }
            this.iimg = 0;
            this.mt.waitForID(this.iimg);
            if (!this.bt.isAlive()) {
                this.bt.start();
            }
            if (this.vms.isEmpty()) {
                this.addMorpher(new ImageMorpher());
            }
            this.bt.resume();
            return;
        }
        catch (Exception exception) {
            System.out.println("BadCancas start : " + exception);
            return;
        }
    }

    public void stop() {
        this.bt.suspend();
    }

    public void paint(Graphics graphics) {
        if (this.gOff == null || this.last != this.getSize()) {
            this.last = this.getSize();
            this.imgOff = this.createImage(this.last.width, this.last.height);
            this.gOff = this.imgOff.getGraphics();
            this.imgnext = this.createImage(this.last.width, this.last.height);
            this.gnext = this.imgnext.getGraphics();
        }
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        if (this.imgOff != null) {
            graphics.drawImage(this.imgOff, 0, 0, this);
        }
    }

    public void nextImage() {
        boolean bl = true;
        while (bl) {
            ++this.iimg;
            if (this.iimg == this.vis.size()) {
                this.iimg = 0;
            }
            if (this.mt.isErrorID(this.iimg)) {
                System.out.println("Error img " + this.iimg);
                continue;
            }
            if (!this.mt.checkID(this.iimg, true)) continue;
            this.setDefaultImg();
            bl = false;
        }
    }

    public void setDefaultImg() {
        Image image = (Image)this.vis.elementAt(this.iimg);
        Dimension dimension = new Dimension(image.getWidth(this), image.getHeight(this));
        if (dimension.width > 0 && dimension.height > 0) {
            if (this.stretch) {
                this.gnext.drawImage(image, 0, 0, this.last.width, this.last.height, this);
                return;
            }
            this.gnext.clearRect(0, 0, this.last.width, this.last.height);
            this.gnext.drawImage(image, (this.last.width - dimension.width) / 2, (this.last.height - dimension.height) / 2, this);
        }
    }

    protected boolean onTip() {
        boolean bl = true;
        try {
            if (this.act == null) {
                if (this.iact == this.vms.size()) {
                    this.iact = 0;
                }
                this.act = (ImageMorpher)this.vms.elementAt(this.iact++);
                this.nextImage();
                this.act.init(this.last);
            }
            if (bl = this.act.tipMorpher(this.gOff, this.imgnext, this.last)) {
                this.act = null;
            }
            this.repaint();
        }
        catch (Exception exception) {
            System.out.println("OnTip :" + exception);
        }
        return bl;
    }

    public class BandThread
    extends Thread {
        public void run() {
            long l = 0L;
            boolean bl = true;
            BandCanvas.this.repaint();
            try {
                while (BandCanvas.this.gOff == null || BandCanvas.this.gnext == null) {
                    Thread.sleep(500L);
                }
                BandCanvas.this.setDefaultImg();
            }
            catch (Exception exception) {
                System.out.println("BandThread init :" + exception);
            }
            while (true) {
                try {
                    while (true) {
                        if (!bl) {
                            long l2 = System.currentTimeMillis();
                            bl = BandCanvas.this.onTip();
                            l = (long)BandCanvas.this.wait - (System.currentTimeMillis() - l2);
                            if (l < 0L) {
                                l = 0L;
                            }
                            Thread.sleep(l);
                            continue;
                        }
                        bl = false;
                        Thread.sleep(BandCanvas.this.delay);
                    }
                }
                catch (Exception exception) {
                    System.out.println("BandThread : " + exception);
                    continue;
                }
                break;
            }
        }

        public BandThread() {
            BandCanvas.this = BandCanvas.this;
        }
    }
}

