// KL Banner

// Edward Smith (edward.smith10@virgin.net)

// for KL Associates (http://www.k-lassociates.com)

// Modify / Use as you wish !



import java.awt.*;

import java.applet.*;

import java.lang.*;



public class KLBanner extends Applet implements Runnable {

 int STEPS=35;

 int DELAY_TIME=50;                     // Thread sleep time

 int DISTANCE=40;                       // Distance travelled by string

 int WIDTH=600;int HEIGHT=150;          // By default

 String text[];                         // Array of string to be shown

 int currentText=0;                     // The current string showing

 int frame=0;                           // Frame count

 boolean starting=true;                 // To see if it's the first string

 Thread runner=null;                    // Our thread

 Image image;                           // Offscreen image buffer

 Graphics graphics;                     // Graphics for offscreen image buffer

 Rectangle first,second=new Rectangle(0,0,0,0);  //Used for the two strings displayed

 Font textFont=new Font("Times",1,16);  // Font used

 Color textColor[];                     // Color for each step as it fades in / out



 public void init() {

  WIDTH=this.size().width;

  HEIGHT=this.size().height;

  Color bg=getColorParameter("bgcolor");

  Color fg=getColorParameter("fgcolor");

  getStrings();

  STEPS=Integer.parseInt(getParameter("steps")!=null?getParameter("steps"):"40");

  DISTANCE=Integer.parseInt(getParameter("distance")!=null?getParameter("distance"):"40");

  DELAY_TIME=Integer.parseInt(getParameter("delay")!=null?getParameter("distance"):"50");



  image=createImage(WIDTH,HEIGHT);

  graphics=image.getGraphics();

  graphics.setFont(textFont);

  textColor=new Color[STEPS];

  for(int i=0;i<STEPS;i++)

   textColor[i]=new Color((int) bg.getRed()+((i*(fg.getRed()-bg.getRed()))/STEPS),

                          (int) bg.getGreen()+((i*(fg.getGreen()-bg.getGreen()))/STEPS),

                          (int) bg.getBlue()+((i*(fg.getBlue()-bg.getBlue()))/STEPS));

  setBackground(bg);

  setForeground(fg);

  newfirst();

 }



 void newfirst(){

 int x=-1,y=-1,a=-1,b=-1;

 while(!check_clip(x,y)){

  x=(int) (Math.random()*WIDTH);

  y=(int) (Math.random()*HEIGHT);

  }

 while(!check_clip(a,b)){

  a=x-DISTANCE+(int) (2*DISTANCE*Math.random());

  b=y-DISTANCE+(int) (2*DISTANCE*Math.random());

  }

 first=new Rectangle(x,y,a,b);

 }



 boolean check_clip(int x,int y){

  int d1=Math.abs(y-second.y),d2=Math.abs(y-second.height);

  return (d1>40)&&(d2>40)&&(x>0)&&(x<WIDTH-graphics.getFontMetrics().stringWidth(text[currentText]))&&(y>graphics.getFontMetrics().getAscent())&&(y<HEIGHT-graphics.getFontMetrics().getDescent());

 }



 public void start(){

 if(runner==null) {

  runner=new Thread(this);

  runner.start();

  }

 }



 public void stop(){

 if(runner!=null && runner.isAlive()) {

  runner.stop();

  runner=null;

  }

 }



 public void run(){

 while(runner!=null){

  repaint();

  try {Thread.sleep(DELAY_TIME);} catch(InterruptedException e) {}

  if(frame==STEPS-2) {

    try {Thread.sleep(DELAY_TIME);} catch(InterruptedException e) {}

    second=first;

    currentText++;

    if(currentText>text.length-1) currentText=currentText%(text.length);

    newfirst();

    starting=false;

    this.showStatus(text[currentText]);

    frame=0;

  } else {

    frame++;

  }

  }

 }



 public void paint(Graphics g){update(g);}



 public void update(Graphics g){

  graphics.clearRect(0,0,WIDTH,HEIGHT);

  graphics.setColor(textColor[frame]);

  int fx=first.x+(int) ((frame*(first.width-first.x))/(2*STEPS-2));

  int fy=first.y+(int) ((frame*(first.height-first.y))/(2*STEPS-2));

  graphics.drawString(text[currentText],fx,fy);

  if(!starting) {

    int sx=second.x+(int) (((frame+STEPS-1)*(second.width-second.x))/(2*STEPS-2));

    int sy=second.y+(int) (((frame+STEPS-1)*(second.height-second.y))/(2*STEPS-2));

    graphics.setColor(textColor[STEPS-frame-1]);

    graphics.drawString(text[(currentText+text.length-1)%text.length],sx,sy);

    }

  g.drawImage(image,0,0,this);

  }



  Color getColorParameter(String name){

   String bg=getParameter(name);

   if(bg==null||bg.equals("")) bg="FFFFFF";

   int r=Integer.parseInt(bg.substring(0,2),16);

   int g=Integer.parseInt(bg.substring(2,4),16);

   int b=Integer.parseInt(bg.substring(4,6),16);

   return new Color(r,g,b);

  }



  void getStrings(){

   int i=0;

   while(getString(i)!=null) i++;

   text=new String[i];

   for(int j=0;j<i;j++) text[j]=getString(j);

  }



  String getString(int i){

   return this.getParameter(""+i);

  }

}



